/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.Callback;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Union;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class Structure {
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    protected static final int CALCULATE_SIZE = -1;
    static final Map layoutInfo = new WeakHashMap();
    static final Map fieldOrder = new WeakHashMap();
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private String encoding;
    private int actualAlignType;
    private int structAlignment;
    private Map structFields;
    private final Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    private boolean autoRead = true;
    private boolean autoWrite = true;
    private Structure[] array;
    private boolean readCalled;
    private static final ThreadLocal reads = new ThreadLocal(){

        protected synchronized Map initialValue() {
            return new HashMap();
        }
    };
    private static final ThreadLocal busy = new ThreadLocal(){

        protected synchronized Set initialValue() {
            return new StructureSet();
        }
    };
    private static final Pointer PLACEHOLDER_MEMORY = new Pointer(0L){

        @Override
        public Pointer share(long l, long l2) {
            return this;
        }
    };

    protected Structure() {
        this(0);
    }

    protected Structure(TypeMapper typeMapper) {
        this(null, 0, typeMapper);
    }

    protected Structure(int n) {
        this(null, n);
    }

    protected Structure(int n, TypeMapper typeMapper) {
        this(null, n, typeMapper);
    }

    protected Structure(Pointer pointer) {
        this(pointer, 0);
    }

    protected Structure(Pointer pointer, int n) {
        this(pointer, n, null);
    }

    protected Structure(Pointer pointer, int n, TypeMapper typeMapper) {
        this.setAlignType(n);
        this.setStringEncoding(Native.getStringEncoding(this.getClass()));
        this.initializeTypeMapper(typeMapper);
        this.validateFields();
        if (pointer != null) {
            this.useMemory(pointer, 0, true);
        } else {
            this.allocateMemory(-1);
        }
        this.initializeFields();
    }

    Map fields() {
        return this.structFields;
    }

    TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    private void initializeTypeMapper(TypeMapper typeMapper) {
        if (typeMapper == null) {
            typeMapper = Native.getTypeMapper(this.getClass());
        }
        this.typeMapper = typeMapper;
        this.layoutChanged();
    }

    private void layoutChanged() {
        if (this.size != -1) {
            this.size = -1;
            if (this.memory instanceof AutoAllocated) {
                this.memory = null;
            }
            this.ensureAllocated();
        }
    }

    protected void setStringEncoding(String string) {
        this.encoding = string;
    }

    protected String getStringEncoding() {
        return this.encoding;
    }

    protected void setAlignType(int n) {
        this.alignType = n;
        if (n == 0 && (n = Native.getStructureAlignment(this.getClass())) == 0) {
            n = Platform.isWindows() ? 3 : 2;
        }
        this.actualAlignType = n;
        this.layoutChanged();
    }

    protected Memory autoAllocate(int n) {
        return new AutoAllocated(n);
    }

    protected void useMemory(Pointer pointer) {
        this.useMemory(pointer, 0);
    }

    protected void useMemory(Pointer pointer, int n) {
        this.useMemory(pointer, n, false);
    }

    void useMemory(Pointer pointer, int n, boolean bl) {
        try {
            this.nativeStrings.clear();
            if (this instanceof ByValue && !bl) {
                byte[] byArray = new byte[this.size()];
                pointer.read(0L, byArray, 0, byArray.length);
                this.memory.write(0L, byArray, 0, byArray.length);
            } else {
                this.memory = pointer.share(n);
                if (this.size == -1) {
                    this.size = this.calculateSize(false);
                }
                if (this.size != -1) {
                    this.memory = pointer.share(n, this.size);
                }
            }
            this.array = null;
            this.readCalled = false;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException(I.I(69908), indexOutOfBoundsException);
        }
    }

    protected void ensureAllocated() {
        this.ensureAllocated(false);
    }

    private void ensureAllocated(boolean bl) {
        if (this.memory == null) {
            this.allocateMemory(bl);
        } else if (this.size == -1) {
            this.size = this.calculateSize(true, bl);
            if (!(this.memory instanceof AutoAllocated)) {
                try {
                    this.memory = this.memory.share(0L, this.size);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException(I.I(69908), indexOutOfBoundsException);
                }
            }
        }
    }

    protected void allocateMemory() {
        this.allocateMemory(false);
    }

    private void allocateMemory(boolean bl) {
        this.allocateMemory(this.calculateSize(true, bl));
    }

    protected void allocateMemory(int n) {
        if (n == -1) {
            n = this.calculateSize(false);
        } else if (n <= 0) {
            throw new IllegalArgumentException(I.I(69865) + n);
        }
        if (n != -1) {
            if (this.memory == null || this.memory instanceof AutoAllocated) {
                this.memory = this.autoAllocate(n);
            }
            this.size = n;
        }
    }

    public int size() {
        this.ensureAllocated();
        return this.size;
    }

    public void clear() {
        this.ensureAllocated();
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        this.ensureAllocated();
        return this.memory;
    }

    static Set busy() {
        return (Set)busy.get();
    }

    static Map reading() {
        return (Map)reads.get();
    }

    void conditionalAutoRead() {
        if (!this.readCalled) {
            this.autoRead();
        }
    }

    public void read() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.readCalled = true;
        this.ensureAllocated();
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        if (this instanceof ByReference) {
            Structure.reading().put(this.getPointer(), this);
        }
        try {
            for (StructField structField : this.fields().values()) {
                this.readField(structField);
            }
        }
        finally {
            Structure.busy().remove(this);
            if (Structure.reading().get(this.getPointer()) == this) {
                Structure.reading().remove(this.getPointer());
            }
        }
    }

    protected int fieldOffset(String string) {
        this.ensureAllocated();
        StructField structField = (StructField)this.fields().get(string);
        if (structField == null) {
            throw new IllegalArgumentException(I.I(69708) + string);
        }
        return structField.offset;
    }

    public Object readField(String string) {
        this.ensureAllocated();
        StructField structField = (StructField)this.fields().get(string);
        if (structField == null) {
            throw new IllegalArgumentException(I.I(69708) + string);
        }
        return this.readField(structField);
    }

    Object getFieldValue(Field field) {
        try {
            return field.get(this);
        }
        catch (Exception exception) {
            throw new Error(I.I(68868) + field.getName() + I.I(68894) + this.getClass(), exception);
        }
    }

    void setFieldValue(Field field, Object object) {
        this.setFieldValue(field, object, false);
    }

    private void setFieldValue(Field field, Object object, boolean bl) {
        try {
            field.set(this, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            int n = field.getModifiers();
            if (Modifier.isFinal(n)) {
                if (bl) {
                    throw new UnsupportedOperationException(I.I(69724) + field.getName() + I.I(68951) + this.getClass() + I.I(16664), illegalAccessException);
                }
                throw new UnsupportedOperationException(I.I(69787) + field.getName() + I.I(68951) + this.getClass(), illegalAccessException);
            }
            throw new Error(I.I(69825) + field.getName() + I.I(68951) + this.getClass(), illegalAccessException);
        }
    }

    static Structure updateStructureByReference(Class clazz, Structure structure, Pointer pointer) {
        if (pointer == null) {
            structure = null;
        } else if (structure == null || !pointer.equals(structure.getPointer())) {
            Structure structure2 = (Structure)Structure.reading().get(pointer);
            if (structure2 != null && clazz.equals(structure2.getClass())) {
                structure = structure2;
                structure.autoRead();
            } else {
                structure = Structure.newInstance(clazz, pointer);
                structure.conditionalAutoRead();
            }
        } else {
            structure.autoRead();
        }
        return structure;
    }

    protected Object readField(StructField structField) {
        Pointer pointer;
        Object object;
        int n = structField.offset;
        Class clazz = structField.type;
        FromNativeConverter fromNativeConverter = structField.readConverter;
        if (fromNativeConverter != null) {
            clazz = fromNativeConverter.nativeType();
        }
        Object object2 = object = Structure.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz) || NativeMapped.class.isAssignableFrom(clazz) || clazz.isArray() ? this.getFieldValue(structField.field) : null;
        Object object3 = clazz == String.class ? ((pointer = this.memory.getPointer(n)) == null ? null : pointer.getString(0L, this.encoding)) : this.memory.getValue(n, clazz, object);
        if (fromNativeConverter != null) {
            object3 = fromNativeConverter.fromNative(object3, structField.context);
            if (object != null && object.equals(object3)) {
                object3 = object;
            }
        }
        if (clazz.equals(String.class) || clazz.equals(WString.class)) {
            this.nativeStrings.put(structField.name + I.I(69602), this.memory.getPointer(n));
            this.nativeStrings.put(structField.name + I.I(69607), object3);
        }
        this.setFieldValue(structField.field, object3, true);
        return object3;
    }

    public void write() {
        if (this.memory == PLACEHOLDER_MEMORY) {
            return;
        }
        this.ensureAllocated();
        if (this instanceof ByValue) {
            this.getTypeInfo();
        }
        if (Structure.busy().contains(this)) {
            return;
        }
        Structure.busy().add(this);
        try {
            for (StructField structField : this.fields().values()) {
                if (structField.isVolatile) continue;
                this.writeField(structField);
            }
        }
        finally {
            Structure.busy().remove(this);
        }
    }

    public void writeField(String string) {
        this.ensureAllocated();
        StructField structField = (StructField)this.fields().get(string);
        if (structField == null) {
            throw new IllegalArgumentException(I.I(69708) + string);
        }
        this.writeField(structField);
    }

    public void writeField(String string, Object object) {
        this.ensureAllocated();
        StructField structField = (StructField)this.fields().get(string);
        if (structField == null) {
            throw new IllegalArgumentException(I.I(69708) + string);
        }
        this.setFieldValue(structField.field, object);
        this.writeField(structField);
    }

    protected void writeField(StructField structField) {
        CharSequence charSequence;
        if (structField.isReadOnly) {
            return;
        }
        int n = structField.offset;
        Object object = this.getFieldValue(structField.field);
        Class clazz = structField.type;
        ToNativeConverter toNativeConverter = structField.writeConverter;
        if (toNativeConverter != null) {
            object = toNativeConverter.toNative(object, new StructureWriteContext(this, structField.field));
            clazz = toNativeConverter.nativeType();
        }
        if (String.class == clazz || WString.class == clazz) {
            boolean bl;
            boolean bl2 = bl = clazz == WString.class;
            if (object != null) {
                if (this.nativeStrings.containsKey(structField.name + I.I(69602)) && object.equals(this.nativeStrings.get(structField.name + I.I(69607)))) {
                    return;
                }
                charSequence = bl ? new NativeString(object.toString(), true) : new NativeString(object.toString(), this.encoding);
                this.nativeStrings.put(structField.name, charSequence);
                object = ((NativeString)charSequence).getPointer();
            } else {
                this.nativeStrings.remove(structField.name);
            }
            this.nativeStrings.remove(structField.name + I.I(69602));
            this.nativeStrings.remove(structField.name + I.I(69607));
        }
        try {
            this.memory.setValue(n, object, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            charSequence = I.I(69612) + structField.name + I.I(69630) + structField.type + (structField.type == clazz ? "" : I.I(69649) + clazz + I.I(16664)) + I.I(69664);
            throw new IllegalArgumentException((String)charSequence, illegalArgumentException);
        }
    }

    protected abstract List getFieldOrder();

    protected final void setFieldOrder(String[] stringArray) {
        throw new Error(I.I(69549));
    }

    protected void sortFields(List list, List list2) {
        block0: for (int j = 0; j < list2.size(); ++j) {
            String string = (String)list2.get(j);
            for (int k = 0; k < list.size(); ++k) {
                Field field = (Field)list.get(k);
                if (!string.equals(field.getName())) continue;
                Collections.swap(list, j, k);
                continue block0;
            }
        }
    }

    protected List getFieldList() {
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = this.getClass();
        while (!clazz.equals(Structure.class)) {
            ArrayList<Field> arrayList2 = new ArrayList<Field>();
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int j = 0; j < fieldArray.length; ++j) {
                int n = fieldArray[j].getModifiers();
                if (Modifier.isStatic(n) || !Modifier.isPublic(n)) continue;
                arrayList2.add(fieldArray[j]);
            }
            arrayList.addAll(0, arrayList2);
            clazz = clazz.getSuperclass();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List fieldOrder() {
        Class<?> clazz = this.getClass();
        Map map = fieldOrder;
        synchronized (map) {
            List list = (List)fieldOrder.get(clazz);
            if (list == null) {
                list = this.getFieldOrder();
                fieldOrder.put(clazz, list);
            }
            return list;
        }
    }

    public static List createFieldsOrder(List list, String ... stringArray) {
        return Structure.createFieldsOrder(list, Arrays.asList(stringArray));
    }

    public static List createFieldsOrder(List list, List list2) {
        ArrayList arrayList = new ArrayList(list.size() + list2.size());
        arrayList.addAll(list);
        arrayList.addAll(list2);
        return Collections.unmodifiableList(arrayList);
    }

    public static List createFieldsOrder(String string) {
        return Collections.unmodifiableList(Collections.singletonList(string));
    }

    public static List createFieldsOrder(String ... stringArray) {
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    private static List sort(Collection collection) {
        ArrayList arrayList = new ArrayList(collection);
        Collections.sort(arrayList);
        return arrayList;
    }

    protected List getFields(boolean bl) {
        HashSet hashSet3;
        List list = this.getFieldList();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (HashSet hashSet3 : list) {
            hashSet2.add(((Field)((Object)hashSet3)).getName());
        }
        List list2 = this.fieldOrder();
        if (list2.size() != list.size() && list.size() > 1) {
            if (bl) {
                throw new Error(I.I(69392) + this.getClass() + I.I(69422) + list2.size() + I.I(69455) + Structure.sort(list2) + I.I(69459) + list.size() + I.I(69455) + Structure.sort(hashSet2) + I.I(16664));
            }
            return null;
        }
        hashSet3 = new HashSet(list2);
        if (!hashSet3.equals(hashSet2)) {
            throw new Error(I.I(69392) + this.getClass() + I.I(69488) + Structure.sort(list2) + I.I(69505) + Structure.sort(hashSet2) + I.I(16664));
        }
        this.sortFields(list, list2);
        return list;
    }

    protected int calculateSize(boolean bl) {
        return this.calculateSize(bl, false);
    }

    static int size(Class clazz) {
        return Structure.size(clazz, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int size(Class clazz, Structure structure) {
        int n;
        LayoutInfo layoutInfo;
        Map map = Structure.layoutInfo;
        synchronized (map) {
            layoutInfo = (LayoutInfo)Structure.layoutInfo.get(clazz);
        }
        int n2 = n = layoutInfo != null && !layoutInfo.variable ? layoutInfo.size : -1;
        if (n == -1) {
            if (structure == null) {
                structure = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
            }
            n = structure.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int calculateSize(boolean bl, boolean bl2) {
        LayoutInfo layoutInfo;
        int n = -1;
        Class<?> clazz = this.getClass();
        Map map = Structure.layoutInfo;
        synchronized (map) {
            layoutInfo = (LayoutInfo)Structure.layoutInfo.get(clazz);
        }
        if (layoutInfo == null || this.alignType != layoutInfo.alignType || this.typeMapper != layoutInfo.typeMapper) {
            layoutInfo = this.deriveLayout(bl, bl2);
        }
        if (layoutInfo != null) {
            this.structAlignment = layoutInfo.alignment;
            this.structFields = layoutInfo.fields;
            if (!layoutInfo.variable) {
                map = Structure.layoutInfo;
                synchronized (map) {
                    if (!Structure.layoutInfo.containsKey(clazz) || this.alignType != 0 || this.typeMapper != null) {
                        Structure.layoutInfo.put(clazz, layoutInfo);
                    }
                }
            }
            n = layoutInfo.size;
        }
        return n;
    }

    private void validateField(String string, Class clazz) {
        ToNativeConverter toNativeConverter;
        if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
            this.validateField(string, toNativeConverter.nativeType());
            return;
        }
        if (clazz.isArray()) {
            this.validateField(string, clazz.getComponentType());
        } else {
            try {
                this.getNativeSize(clazz);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = I.I(69207) + this.getClass() + I.I(69235) + string + I.I(69250) + clazz + I.I(67722) + illegalArgumentException.getMessage();
                throw new IllegalArgumentException(string2, illegalArgumentException);
            }
        }
    }

    private void validateFields() {
        List list = this.getFieldList();
        for (Field field : list) {
            this.validateField(field.getName(), field.getType());
        }
    }

    private LayoutInfo deriveLayout(boolean bl, boolean bl2) {
        int n = 0;
        List list = this.getFields(bl);
        if (list == null) {
            return null;
        }
        LayoutInfo layoutInfo = new LayoutInfo();
        layoutInfo.alignType = this.alignType;
        layoutInfo.typeMapper = this.typeMapper;
        boolean bl3 = true;
        for (Field field : list) {
            int n2 = field.getModifiers();
            Class clazz = field.getType();
            if (clazz.isArray()) {
                layoutInfo.variable = true;
            }
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(n2);
            structField.isReadOnly = Modifier.isFinal(n2);
            if (structField.isReadOnly) {
                if (!Platform.RO_FIELDS) {
                    throw new IllegalArgumentException(I.I(68900) + field.getName() + I.I(68951) + this.getClass() + I.I(16664));
                }
                field.setAccessible(true);
            }
            structField.field = field;
            structField.name = field.getName();
            structField.type = clazz;
            if (Callback.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                throw new IllegalArgumentException(I.I(68961) + field.getName() + I.I(68988));
            }
            if (clazz.isArray() && Structure.class.equals(clazz.getComponentType())) {
                String string = I.I(69011);
                throw new IllegalArgumentException(string);
            }
            int n3 = 1;
            if (Modifier.isPublic(field.getModifiers())) {
                Object object;
                ToNativeConverter toNativeConverter;
                Object object2 = this.getFieldValue(structField.field);
                if (object2 == null && clazz.isArray()) {
                    if (bl) {
                        throw new IllegalStateException(I.I(69120));
                    }
                    return null;
                }
                Class clazz2 = clazz;
                if (NativeMapped.class.isAssignableFrom(clazz)) {
                    toNativeConverter = NativeMappedConverter.getInstance(clazz);
                    clazz2 = ((NativeMappedConverter)toNativeConverter).nativeType();
                    structField.writeConverter = toNativeConverter;
                    structField.readConverter = toNativeConverter;
                    structField.context = new StructureReadContext(this, field);
                } else if (this.typeMapper != null) {
                    toNativeConverter = this.typeMapper.getToNativeConverter(clazz);
                    object = this.typeMapper.getFromNativeConverter(clazz);
                    if (toNativeConverter != null && object != null) {
                        clazz2 = (object2 = toNativeConverter.toNative(object2, new StructureWriteContext(this, structField.field))) != null ? object2.getClass() : Pointer.class;
                        structField.writeConverter = toNativeConverter;
                        structField.readConverter = object;
                        structField.context = new StructureReadContext(this, field);
                    } else if (toNativeConverter != null || object != null) {
                        String string = I.I(69153) + clazz;
                        throw new IllegalArgumentException(string);
                    }
                }
                if (object2 == null) {
                    object2 = this.initializeField(structField.field, clazz);
                }
                try {
                    structField.size = this.getNativeSize(clazz2, object2);
                    n3 = this.getNativeAlignment(clazz2, object2, bl3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!bl && this.typeMapper == null) {
                        return null;
                    }
                    object = I.I(69207) + this.getClass() + I.I(69235) + structField.name + I.I(69250) + structField.type + I.I(67722) + illegalArgumentException.getMessage();
                    throw new IllegalArgumentException((String)object, illegalArgumentException);
                }
                if (n3 == 0) {
                    throw new Error(I.I(69254) + structField.name + I.I(68951) + this.getClass());
                }
                layoutInfo.alignment = Math.max(layoutInfo.alignment, n3);
                if (n % n3 != 0) {
                    n += n3 - n % n3;
                }
                if (this instanceof Union) {
                    structField.offset = 0;
                    n = Math.max(n, structField.size);
                } else {
                    structField.offset = n;
                    n += structField.size;
                }
                layoutInfo.fields.put(structField.name, structField);
                if (layoutInfo.typeInfoField == null || ((LayoutInfo)layoutInfo).typeInfoField.size < structField.size || ((LayoutInfo)layoutInfo).typeInfoField.size == structField.size && Structure.class.isAssignableFrom(structField.type)) {
                    layoutInfo.typeInfoField = structField;
                }
            }
            bl3 = false;
        }
        if (n > 0) {
            int n4 = this.addPadding(n, layoutInfo.alignment);
            if (this instanceof ByValue && !bl2) {
                this.getTypeInfo();
            }
            layoutInfo.size = n4;
            return layoutInfo;
        }
        throw new IllegalArgumentException(I.I(69290) + this.getClass() + I.I(69301));
    }

    private void initializeFields() {
        List list = this.getFieldList();
        for (Field field : list) {
            try {
                Object object = field.get(this);
                if (object != null) continue;
                this.initializeField(field, field.getType());
            }
            catch (Exception exception) {
                throw new Error(I.I(68868) + field.getName() + I.I(68894) + this.getClass(), exception);
            }
        }
    }

    private Object initializeField(Field field, Class clazz) {
        Object object = null;
        if (Structure.class.isAssignableFrom(clazz) && !ByReference.class.isAssignableFrom(clazz)) {
            try {
                object = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                this.setFieldValue(field, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = I.I(68827);
                throw new IllegalArgumentException(string, illegalArgumentException);
            }
        } else if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            object = nativeMappedConverter.defaultValue();
            this.setFieldValue(field, object);
        }
        return object;
    }

    private int addPadding(int n) {
        return this.addPadding(n, this.structAlignment);
    }

    private int addPadding(int n, int n2) {
        if (this.actualAlignType != 1 && n % n2 != 0) {
            n += n2 - n % n2;
        }
        return n;
    }

    protected int getStructAlignment() {
        if (this.size == -1) {
            this.calculateSize(true);
        }
        return this.structAlignment;
    }

    protected int getNativeAlignment(Class clazz, Object object, boolean bl) {
        int n = 1;
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
            clazz = nativeMappedConverter.nativeType();
            object = nativeMappedConverter.toNative(object, new ToNativeContext());
        }
        int n2 = Native.getNativeSize(clazz, object);
        if (clazz.isPrimitive() || Long.class == clazz || Integer.class == clazz || Short.class == clazz || Character.class == clazz || Byte.class == clazz || Boolean.class == clazz || Float.class == clazz || Double.class == clazz) {
            n = n2;
        } else if (Pointer.class.isAssignableFrom(clazz) && !Function.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz) || WString.class == clazz || String.class == clazz) {
            n = Pointer.SIZE;
        } else if (Structure.class.isAssignableFrom(clazz)) {
            if (ByReference.class.isAssignableFrom(clazz)) {
                n = Pointer.SIZE;
            } else {
                if (object == null) {
                    object = Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
                }
                n = ((Structure)object).getStructAlignment();
            }
        } else if (clazz.isArray()) {
            n = this.getNativeAlignment(clazz.getComponentType(), null, bl);
        } else {
            throw new IllegalArgumentException(I.I(68791) + clazz + I.I(68797));
        }
        if (this.actualAlignType == 1) {
            n = 1;
        } else if (this.actualAlignType == 3) {
            n = Math.min(8, n);
        } else if (this.actualAlignType == 2) {
            if (!(bl && Platform.isMac() && Platform.isPPC())) {
                n = Math.min(Native.MAX_ALIGNMENT, n);
            }
            if (!bl && Platform.isAIX() && (clazz == Double.TYPE || clazz == Double.class)) {
                n = 4;
            }
        }
        return n;
    }

    public String toString() {
        return this.toString(Boolean.getBoolean(I.I(68775)));
    }

    public String toString(boolean bl) {
        return this.toString(0, true, bl);
    }

    private String format(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(I.I(1448));
        return string.substring(n + 1);
    }

    private String toString(int n, boolean bl, boolean bl2) {
        Object object;
        this.ensureAllocated();
        String string = System.getProperty(I.I(-2623));
        String string2 = this.format(this.getClass()) + I.I(-1736) + this.getPointer() + I.I(16664);
        if (!(this.getPointer() instanceof Memory)) {
            string2 = string2 + I.I(16661) + this.size() + I.I(68740);
        }
        String string3 = "";
        for (int j = 0; j < n; ++j) {
            string3 = string3 + I.I(68748);
        }
        String string4 = string;
        if (!bl) {
            string4 = I.I(68751);
        } else {
            Iterator iterator = this.fields().values().iterator();
            while (iterator.hasNext()) {
                object = (StructField)iterator.next();
                Object object2 = this.getFieldValue(((StructField)object).field);
                String string5 = this.format(((StructField)object).type);
                String string6 = "";
                string4 = string4 + string3;
                if (((StructField)object).type.isArray() && object2 != null) {
                    string5 = this.format(((StructField)object).type.getComponentType());
                    string6 = I.I(17067) + Array.getLength(object2) + I.I(-1397);
                }
                string4 = string4 + I.I(68748) + string5 + I.I(1904) + ((StructField)object).name + string6 + I.I(-1522) + Integer.toHexString(((StructField)object).offset);
                if (object2 instanceof Structure) {
                    object2 = ((Structure)object2).toString(n + 1, !(object2 instanceof ByReference), bl2);
                }
                string4 = string4 + I.I(21763);
                string4 = object2 instanceof Long ? string4 + Long.toHexString((Long)object2) : (object2 instanceof Integer ? string4 + Integer.toHexString((Integer)object2) : (object2 instanceof Short ? string4 + Integer.toHexString(((Short)object2).shortValue()) : (object2 instanceof Byte ? string4 + Integer.toHexString(((Byte)object2).byteValue()) : string4 + String.valueOf(object2).trim())));
                string4 = string4 + string;
                if (iterator.hasNext()) continue;
                string4 = string4 + string3 + I.I(68756);
            }
        }
        if (n == 0 && bl2) {
            int n2 = 4;
            string4 = string4 + string + I.I(68758) + string;
            object = this.getPointer().getByteArray(0L, this.size());
            for (int j = 0; j < ((Object)object).length; ++j) {
                if (j % 4 == 0) {
                    string4 = string4 + I.I(17067);
                }
                if (object[j] >= 0 && object[j] < 16) {
                    string4 = string4 + I.I(68770);
                }
                string4 = string4 + Integer.toHexString(object[j] & 0xFF);
                if (j % 4 != 3 || j >= ((Object)object).length - 1) continue;
                string4 = string4 + I.I(-1397) + string;
            }
            string4 = string4 + I.I(-1397);
        }
        return string2 + I.I(68772) + string4;
    }

    public Structure[] toArray(Structure[] structureArray) {
        int n;
        this.ensureAllocated();
        if (this.memory instanceof AutoAllocated) {
            Memory memory = (Memory)this.memory;
            n = structureArray.length * this.size();
            if (memory.size() < (long)n) {
                this.useMemory(this.autoAllocate(n));
            }
        }
        structureArray[0] = this;
        int n2 = this.size();
        for (n = 1; n < structureArray.length; ++n) {
            structureArray[n] = Structure.newInstance(this.getClass(), this.memory.share(n * n2, n2));
            structureArray[n].conditionalAutoRead();
        }
        if (!(this instanceof ByValue)) {
            this.array = structureArray;
        }
        return structureArray;
    }

    public Structure[] toArray(int n) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), n));
    }

    private Class baseClass() {
        if ((this instanceof ByReference || this instanceof ByValue) && Structure.class.isAssignableFrom(this.getClass().getSuperclass())) {
            return this.getClass().getSuperclass();
        }
        return this.getClass();
    }

    public boolean dataEquals(Structure structure) {
        return this.dataEquals(structure, false);
    }

    public boolean dataEquals(Structure structure, boolean bl) {
        byte[] byArray;
        byte[] byArray2;
        if (bl) {
            structure.getPointer().clear(structure.size());
            structure.write();
            this.getPointer().clear(this.size());
            this.write();
        }
        if ((byArray2 = structure.getPointer().getByteArray(0L, structure.size())).length == (byArray = this.getPointer().getByteArray(0L, this.size())).length) {
            for (int j = 0; j < byArray2.length; ++j) {
                if (byArray2[j] == byArray[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean equals(Object object) {
        return object instanceof Structure && object.getClass() == this.getClass() && ((Structure)object).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        Pointer pointer = this.getPointer();
        if (pointer != null) {
            return this.getPointer().hashCode();
        }
        return this.getClass().hashCode();
    }

    protected void cacheTypeInfo(Pointer pointer) {
        this.typeInfo = pointer.peer;
    }

    Pointer getFieldTypeInfo(StructField structField) {
        ToNativeConverter toNativeConverter;
        Class clazz = structField.type;
        Object object = this.getFieldValue(structField.field);
        if (this.typeMapper != null && (toNativeConverter = this.typeMapper.getToNativeConverter(clazz)) != null) {
            clazz = toNativeConverter.nativeType();
            object = toNativeConverter.toNative(object, new ToNativeContext());
        }
        return FFIType.get(object, clazz);
    }

    Pointer getTypeInfo() {
        Pointer pointer = Structure.getTypeInfo(this);
        this.cacheTypeInfo(pointer);
        return pointer;
    }

    public void setAutoSynch(boolean bl) {
        this.setAutoRead(bl);
        this.setAutoWrite(bl);
    }

    public void setAutoRead(boolean bl) {
        this.autoRead = bl;
    }

    public boolean getAutoRead() {
        return this.autoRead;
    }

    public void setAutoWrite(boolean bl) {
        this.autoWrite = bl;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    static Pointer getTypeInfo(Object object) {
        return FFIType.get(object);
    }

    private static Structure newInstance(Class clazz, long l) {
        try {
            Structure structure = Structure.newInstance(clazz, l == 0L ? PLACEHOLDER_MEMORY : new Pointer(l));
            if (l != 0L) {
                structure.conditionalAutoRead();
            }
            return structure;
        }
        catch (Throwable throwable) {
            System.err.println(I.I(68708) + throwable);
            return null;
        }
    }

    public static Structure newInstance(Class clazz, Pointer pointer) throws IllegalArgumentException {
        try {
            Constructor constructor = clazz.getConstructor(Pointer.class);
            return (Structure)constructor.newInstance(pointer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (InstantiationException instantiationException) {
            String string = I.I(66329) + clazz;
            throw new IllegalArgumentException(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = I.I(68571) + clazz + I.I(68617);
            throw new IllegalArgumentException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = I.I(68655) + clazz;
            invocationTargetException.printStackTrace();
            throw new IllegalArgumentException(string, invocationTargetException);
        }
        Structure structure = Structure.newInstance(clazz);
        if (pointer != PLACEHOLDER_MEMORY) {
            structure.useMemory(pointer);
        }
        return structure;
    }

    public static Structure newInstance(Class clazz) throws IllegalArgumentException {
        try {
            Structure structure = (Structure)clazz.newInstance();
            if (structure instanceof ByValue) {
                structure.allocateMemory();
            }
            return structure;
        }
        catch (InstantiationException instantiationException) {
            String string = I.I(66329) + clazz;
            throw new IllegalArgumentException(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            String string = I.I(68571) + clazz + I.I(68589);
            throw new IllegalArgumentException(string, illegalAccessException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StructField typeInfoField() {
        LayoutInfo layoutInfo;
        Map map = Structure.layoutInfo;
        synchronized (map) {
            layoutInfo = (LayoutInfo)Structure.layoutInfo.get(this.getClass());
        }
        if (layoutInfo != null) {
            return layoutInfo.typeInfoField;
        }
        return null;
    }

    private static void structureArrayCheck(Structure[] structureArray) {
        if (ByReference[].class.isAssignableFrom(structureArray.getClass())) {
            return;
        }
        Pointer pointer = structureArray[0].getPointer();
        int n = structureArray[0].size();
        for (int j = 1; j < structureArray.length; ++j) {
            if (structureArray[j].getPointer().peer == pointer.peer + (long)(n * j)) continue;
            String string = I.I(68472) + j + I.I(16664);
            throw new IllegalArgumentException(string);
        }
    }

    public static void autoRead(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoRead();
        } else {
            for (int j = 0; j < structureArray.length; ++j) {
                if (structureArray[j] == null) continue;
                structureArray[j].autoRead();
            }
        }
    }

    public void autoRead() {
        if (this.getAutoRead()) {
            this.read();
            if (this.array != null) {
                for (int j = 1; j < this.array.length; ++j) {
                    this.array[j].autoRead();
                }
            }
        }
    }

    public static void autoWrite(Structure[] structureArray) {
        Structure.structureArrayCheck(structureArray);
        if (structureArray[0].array == structureArray) {
            structureArray[0].autoWrite();
        } else {
            for (int j = 0; j < structureArray.length; ++j) {
                if (structureArray[j] == null) continue;
                structureArray[j].autoWrite();
            }
        }
    }

    public void autoWrite() {
        if (this.getAutoWrite()) {
            this.write();
            if (this.array != null) {
                for (int j = 1; j < this.array.length; ++j) {
                    this.array[j].autoWrite();
                }
            }
        }
    }

    protected int getNativeSize(Class clazz) {
        return this.getNativeSize(clazz, null);
    }

    protected int getNativeSize(Class clazz, Object object) {
        return Native.getNativeSize(clazz, object);
    }

    static void validate(Class clazz) {
        Structure.newInstance(clazz, PLACEHOLDER_MEMORY);
    }

    private static class AutoAllocated
    extends Memory {
        public AutoAllocated(int n) {
            super(n);
            super.clear();
        }

        @Override
        public String toString() {
            return I.I(70102) + super.toString();
        }
    }

    static class FFIType
    extends Structure {
        private static final Map typeInfoMap = new WeakHashMap();
        private static final int FFI_TYPE_STRUCT = 13;
        public size_t size;
        public short alignment;
        public short type = (short)13;
        public Pointer elements;

        private FFIType(Structure structure) {
            Pointer[] pointerArray;
            structure.ensureAllocated(true);
            if (structure instanceof Union) {
                StructField structField = ((Union)structure).typeInfoField();
                pointerArray = new Pointer[]{FFIType.get(structure.getFieldValue(structField.field), structField.type), null};
            } else {
                pointerArray = new Pointer[structure.fields().size() + 1];
                int n = 0;
                for (StructField structField : structure.fields().values()) {
                    pointerArray[n++] = structure.getFieldTypeInfo(structField);
                }
            }
            this.init(pointerArray);
        }

        private FFIType(Object object, Class clazz) {
            int n = Array.getLength(object);
            Pointer[] pointerArray = new Pointer[n + 1];
            Pointer pointer = FFIType.get(null, clazz.getComponentType());
            for (int j = 0; j < n; ++j) {
                pointerArray[j] = pointer;
            }
            this.init(pointerArray);
        }

        @Override
        protected List getFieldOrder() {
            return Arrays.asList(I.I(69993), I.I(69998), I.I(70008), I.I(70013));
        }

        private void init(Pointer[] pointerArray) {
            this.elements = new Memory(Pointer.SIZE * pointerArray.length);
            this.elements.write(0L, pointerArray, 0, pointerArray.length);
            this.write();
        }

        static Pointer get(Object object) {
            if (object == null) {
                return FFITypes.ffi_type_pointer;
            }
            if (object instanceof Class) {
                return FFIType.get(null, (Class)object);
            }
            return FFIType.get(object, object.getClass());
        }

        private static Pointer get(Object object, Class clazz) {
            Object object2;
            TypeMapper typeMapper = Native.getTypeMapper(clazz);
            if (typeMapper != null && (object2 = typeMapper.getToNativeConverter(clazz)) != null) {
                clazz = object2.nativeType();
            }
            object2 = typeInfoMap;
            synchronized (object2) {
                Object v = typeInfoMap.get(clazz);
                if (v instanceof Pointer) {
                    return (Pointer)v;
                }
                if (v instanceof FFIType) {
                    return ((FFIType)v).getPointer();
                }
                if (Platform.HAS_BUFFERS && Buffer.class.isAssignableFrom(clazz) || Callback.class.isAssignableFrom(clazz)) {
                    typeInfoMap.put(clazz, FFITypes.ffi_type_pointer);
                    return FFITypes.ffi_type_pointer;
                }
                if (Structure.class.isAssignableFrom(clazz)) {
                    if (object == null) {
                        object = FFIType.newInstance(clazz, PLACEHOLDER_MEMORY);
                    }
                    if (ByReference.class.isAssignableFrom(clazz)) {
                        typeInfoMap.put(clazz, FFITypes.ffi_type_pointer);
                        return FFITypes.ffi_type_pointer;
                    }
                    FFIType fFIType = new FFIType((Structure)object);
                    typeInfoMap.put(clazz, fFIType);
                    return fFIType.getPointer();
                }
                if (NativeMapped.class.isAssignableFrom(clazz)) {
                    NativeMappedConverter nativeMappedConverter = NativeMappedConverter.getInstance(clazz);
                    return FFIType.get(nativeMappedConverter.toNative(object, new ToNativeContext()), nativeMappedConverter.nativeType());
                }
                if (clazz.isArray()) {
                    FFIType fFIType = new FFIType(object, clazz);
                    typeInfoMap.put(object, fFIType);
                    return fFIType.getPointer();
                }
                throw new IllegalArgumentException(I.I(69975) + clazz);
            }
        }

        static {
            if (Native.POINTER_SIZE == 0) {
                throw new Error(I.I(-1710));
            }
            if (FFITypes.ffi_type_void == null) {
                throw new Error(I.I(69949));
            }
            typeInfoMap.put(Void.TYPE, FFITypes.ffi_type_void);
            typeInfoMap.put(Void.class, FFITypes.ffi_type_void);
            typeInfoMap.put(Float.TYPE, FFITypes.ffi_type_float);
            typeInfoMap.put(Float.class, FFITypes.ffi_type_float);
            typeInfoMap.put(Double.TYPE, FFITypes.ffi_type_double);
            typeInfoMap.put(Double.class, FFITypes.ffi_type_double);
            typeInfoMap.put(Long.TYPE, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Long.class, FFITypes.ffi_type_sint64);
            typeInfoMap.put(Integer.TYPE, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Integer.class, FFITypes.ffi_type_sint32);
            typeInfoMap.put(Short.TYPE, FFITypes.ffi_type_sint16);
            typeInfoMap.put(Short.class, FFITypes.ffi_type_sint16);
            Pointer pointer = Native.WCHAR_SIZE == 2 ? FFITypes.ffi_type_uint16 : FFITypes.ffi_type_uint32;
            typeInfoMap.put(Character.TYPE, pointer);
            typeInfoMap.put(Character.class, pointer);
            typeInfoMap.put(Byte.TYPE, FFITypes.ffi_type_sint8);
            typeInfoMap.put(Byte.class, FFITypes.ffi_type_sint8);
            typeInfoMap.put(Pointer.class, FFITypes.ffi_type_pointer);
            typeInfoMap.put(String.class, FFITypes.ffi_type_pointer);
            typeInfoMap.put(WString.class, FFITypes.ffi_type_pointer);
            typeInfoMap.put(Boolean.TYPE, FFITypes.ffi_type_uint32);
            typeInfoMap.put(Boolean.class, FFITypes.ffi_type_uint32);
        }

        private static class FFITypes {
            private static Pointer ffi_type_void;
            private static Pointer ffi_type_float;
            private static Pointer ffi_type_double;
            private static Pointer ffi_type_longdouble;
            private static Pointer ffi_type_uint8;
            private static Pointer ffi_type_sint8;
            private static Pointer ffi_type_uint16;
            private static Pointer ffi_type_sint16;
            private static Pointer ffi_type_uint32;
            private static Pointer ffi_type_sint32;
            private static Pointer ffi_type_uint64;
            private static Pointer ffi_type_sint64;
            private static Pointer ffi_type_pointer;

            private FFITypes() {
            }
        }

        public static class size_t
        extends IntegerType {
            private static final long serialVersionUID = 1L;

            public size_t() {
                this(0L);
            }

            public size_t(long l) {
                super(Native.SIZE_T_SIZE, l);
            }
        }
    }

    protected static class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public boolean isReadOnly;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        protected StructField() {
        }

        public String toString() {
            return this.name + I.I(-1522) + this.offset + I.I(17067) + this.size + I.I(69455) + this.type + I.I(16664);
        }
    }

    private static class LayoutInfo {
        private int size = -1;
        private int alignment = 1;
        private final Map fields = Collections.synchronizedMap(new LinkedHashMap());
        private int alignType = 0;
        private TypeMapper typeMapper;
        private boolean variable;
        private StructField typeInfoField;

        private LayoutInfo() {
        }
    }

    static class StructureSet
    extends AbstractCollection
    implements Set {
        Structure[] elements;
        private int count;

        StructureSet() {
        }

        private void ensureCapacity(int n) {
            if (this.elements == null) {
                this.elements = new Structure[n * 3 / 2];
            } else if (this.elements.length < n) {
                Structure[] structureArray = new Structure[n * 3 / 2];
                System.arraycopy(this.elements, 0, structureArray, 0, this.elements.length);
                this.elements = structureArray;
            }
        }

        public Structure[] getElements() {
            return this.elements;
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf((Structure)object) != -1;
        }

        @Override
        public boolean add(Structure structure) {
            if (!this.contains(structure)) {
                this.ensureCapacity(this.count + 1);
                this.elements[this.count++] = structure;
            }
            return true;
        }

        private int indexOf(Structure structure) {
            for (int j = 0; j < this.count; ++j) {
                Structure structure2 = this.elements[j];
                if (structure != structure2 && (structure.getClass() != structure2.getClass() || structure.size() != structure2.size() || !structure.getPointer().equals(structure2.getPointer()))) continue;
                return j;
            }
            return -1;
        }

        @Override
        public boolean remove(Object object) {
            int n = this.indexOf((Structure)object);
            if (n != -1) {
                if (--this.count >= 0) {
                    this.elements[n] = this.elements[this.count];
                    this.elements[this.count] = null;
                }
                return true;
            }
            return false;
        }

        @Override
        public Iterator iterator() {
            Structure[] structureArray = new Structure[this.count];
            if (this.count > 0) {
                System.arraycopy(this.elements, 0, structureArray, 0, this.count);
            }
            return Arrays.asList(structureArray).iterator();
        }
    }

    public static interface ByReference {
    }

    public static interface ByValue {
    }
}

