/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List natives = new ArrayList();
    private Object[] original;

    public StringArray(String[] stringArray) {
        this(stringArray, false);
    }

    public StringArray(String[] stringArray, boolean bl) {
        this((Object[])stringArray, bl ? I.I(-636) : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] stringArray, String string) {
        this((Object[])stringArray, string);
    }

    public StringArray(WString[] wStringArray) {
        this(wStringArray, I.I(-636));
    }

    private StringArray(Object[] objectArray, String string) {
        super((objectArray.length + 1) * Pointer.SIZE);
        this.original = objectArray;
        this.encoding = string;
        for (int j = 0; j < objectArray.length; ++j) {
            Pointer pointer = null;
            if (objectArray[j] != null) {
                NativeString nativeString = new NativeString(objectArray[j].toString(), string);
                this.natives.add(nativeString);
                pointer = nativeString.getPointer();
            }
            this.setPointer(Pointer.SIZE * j, pointer);
        }
        this.setPointer(Pointer.SIZE * objectArray.length, null);
    }

    @Override
    public void read() {
        boolean bl = this.original instanceof WString[];
        boolean bl2 = I.I(-636).equals(this.encoding);
        for (int j = 0; j < this.original.length; ++j) {
            Pointer pointer = this.getPointer(j * Pointer.SIZE);
            CharSequence charSequence = null;
            if (pointer != null) {
                String string = charSequence = bl2 ? pointer.getWideString(0L) : pointer.getString(0L, this.encoding);
                if (bl) {
                    charSequence = new WString((String)charSequence);
                }
            }
            this.original[j] = charSequence;
        }
    }

    @Override
    public String toString() {
        boolean bl = I.I(-636).equals(this.encoding);
        String string = bl ? I.I(-620) : I.I(-603);
        string = string + Arrays.asList(this.original);
        return string;
    }
}

