/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.ELFAnalyser;
import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Platform {
    public static final int UNSPECIFIED = -1;
    public static final int MAC = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int SOLARIS = 3;
    public static final int FREEBSD = 4;
    public static final int OPENBSD = 5;
    public static final int WINDOWSCE = 6;
    public static final int AIX = 7;
    public static final int ANDROID = 8;
    public static final int GNU = 9;
    public static final int KFREEBSD = 10;
    public static final int NETBSD = 11;
    public static final boolean RO_FIELDS;
    public static final boolean HAS_BUFFERS;
    public static final boolean HAS_AWT;
    public static final boolean HAS_JAWT;
    public static final String MATH_LIBRARY_NAME;
    public static final String C_LIBRARY_NAME;
    public static final boolean HAS_DLL_CALLBACKS;
    public static final String RESOURCE_PREFIX;
    private static final int osType;
    public static final String ARCH;

    private Platform() {
    }

    public static final int getOSType() {
        return osType;
    }

    public static final boolean isMac() {
        return osType == 0;
    }

    public static final boolean isAndroid() {
        return osType == 8;
    }

    public static final boolean isLinux() {
        return osType == 1;
    }

    public static final boolean isAIX() {
        return osType == 7;
    }

    public static final boolean isAix() {
        return Platform.isAIX();
    }

    public static final boolean isWindowsCE() {
        return osType == 6;
    }

    public static final boolean isWindows() {
        return osType == 2 || osType == 6;
    }

    public static final boolean isSolaris() {
        return osType == 3;
    }

    public static final boolean isFreeBSD() {
        return osType == 4;
    }

    public static final boolean isOpenBSD() {
        return osType == 5;
    }

    public static final boolean isNetBSD() {
        return osType == 11;
    }

    public static final boolean isGNU() {
        return osType == 9;
    }

    public static final boolean iskFreeBSD() {
        return osType == 10;
    }

    public static final boolean isX11() {
        return !Platform.isWindows() && !Platform.isMac();
    }

    public static final boolean hasRuntimeExec() {
        return !Platform.isWindowsCE() || !I.I(-1802).equals(System.getProperty(I.I(-2192)));
    }

    public static final boolean is64Bit() {
        String string = System.getProperty(I.I(-1857), System.getProperty(I.I(-1837)));
        if (string != null) {
            return I.I(-1818).equals(string);
        }
        if (I.I(-1906).equals(ARCH) || I.I(-1815).equals(ARCH) || I.I(-1917).equals(ARCH) || I.I(-1877).equals(ARCH) || I.I(-1810).equals(ARCH) || I.I(20167).equals(ARCH)) {
            return true;
        }
        return Native.POINTER_SIZE == 8;
    }

    public static final boolean isIntel() {
        return ARCH.startsWith(I.I(31971));
    }

    public static final boolean isPPC() {
        return ARCH.startsWith(I.I(31980));
    }

    public static final boolean isARM() {
        return ARCH.startsWith(I.I(-2045));
    }

    public static final boolean isSPARC() {
        return ARCH.startsWith(I.I(-1863));
    }

    static String getCanonicalArchitecture(String string, boolean bl) {
        string = string.toLowerCase().trim();
        if (I.I(-1935).equals(string)) {
            string = I.I(31980);
        } else if (I.I(-1927).equals(string)) {
            string = I.I(-1917);
        } else if (I.I(31956).equals(string) || I.I(-1911).equals(string)) {
            string = I.I(31971);
        } else if (I.I(20173).equals(string) || I.I(20167).equals(string)) {
            string = I.I(-1906);
        }
        if (I.I(-1917).equals(string) && I.I(-1899).equals(System.getProperty(I.I(-1892)))) {
            string = I.I(-1877);
        }
        if (I.I(-2045).equals(string) && bl) {
            string = I.I(-1869);
        }
        return string;
    }

    private static boolean isSoftFloat() {
        try {
            File file = new File(I.I(-1950));
            ELFAnalyser eLFAnalyser = ELFAnalyser.analyse(file.getCanonicalPath());
            return eLFAnalyser.isArmSoftFloat();
        }
        catch (IOException iOException) {
            Logger.getLogger(Platform.class.getName()).log(Level.FINE, null, iOException);
            return false;
        }
    }

    static String getNativeLibraryResourcePrefix() {
        String string = System.getProperty(I.I(-1961));
        if (string != null) {
            return string;
        }
        return Platform.getNativeLibraryResourcePrefix(Platform.getOSType(), System.getProperty(I.I(8044)), System.getProperty(I.I(2639)));
    }

    static String getNativeLibraryResourcePrefix(int n, String string, String string2) {
        return Platform.getNativeLibraryResourcePrefix(n, string, string2, Platform.isSoftFloat());
    }

    static String getNativeLibraryResourcePrefix(int n, String string, String string2, boolean bl) {
        String string3;
        string = Platform.getCanonicalArchitecture(string, bl);
        switch (n) {
            case 8: {
                if (string.startsWith(I.I(-2045))) {
                    string = I.I(-2045);
                }
                string3 = I.I(-2041) + string;
                break;
            }
            case 2: {
                string3 = I.I(-2032) + string;
                break;
            }
            case 6: {
                string3 = I.I(-2025) + string;
                break;
            }
            case 0: {
                string3 = I.I(-2018);
                break;
            }
            case 1: {
                string3 = I.I(-2011) + string;
                break;
            }
            case 3: {
                string3 = I.I(-2004) + string;
                break;
            }
            case 4: {
                string3 = I.I(-1997) + string;
                break;
            }
            case 5: {
                string3 = I.I(-1988) + string;
                break;
            }
            case 11: {
                string3 = I.I(-1979) + string;
                break;
            }
            case 10: {
                string3 = I.I(-1971) + string;
                break;
            }
            default: {
                string3 = string2.toLowerCase();
                int n2 = string3.indexOf(I.I(1904));
                if (n2 != -1) {
                    string3 = string3.substring(0, n2);
                }
                string3 = string3 + I.I(2604) + string;
            }
        }
        return string3;
    }

    static {
        String string = System.getProperty(I.I(2639));
        if (string.startsWith(I.I(-2205))) {
            if (I.I(-2199).equals(System.getProperty(I.I(-2192)).toLowerCase())) {
                osType = 8;
                System.setProperty(I.I(-2179), I.I(10201));
            } else {
                osType = 1;
            }
        } else {
            osType = string.startsWith(I.I(-2166)) ? 7 : (string.startsWith(I.I(-2162)) || string.startsWith(I.I(-2158)) ? 0 : (string.startsWith(I.I(-2151)) ? 6 : (string.startsWith(I.I(-2140)) ? 2 : (string.startsWith(I.I(-2132)) || string.startsWith(I.I(-2124)) ? 3 : (string.startsWith(I.I(-2118)) ? 4 : (string.startsWith(I.I(-2110)) ? 5 : (string.equalsIgnoreCase(I.I(-2102)) ? 9 : (string.equalsIgnoreCase(I.I(-2098)) ? 10 : (string.equalsIgnoreCase(I.I(-2085)) ? 11 : -1)))))))));
        }
        boolean bl = false;
        try {
            Class.forName(I.I(-2078));
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        HAS_AWT = osType != 6 && osType != 8 && osType != 7;
        HAS_JAWT = HAS_AWT && osType != 0;
        HAS_BUFFERS = bl;
        boolean bl2 = RO_FIELDS = osType != 6;
        String string2 = osType == 2 ? I.I(-2062) : (C_LIBRARY_NAME = osType == 6 ? I.I(-2055) : I.I(-2047));
        MATH_LIBRARY_NAME = osType == 2 ? I.I(-2062) : (osType == 6 ? I.I(-2055) : "m");
        HAS_DLL_CALLBACKS = osType == 2;
        ARCH = Platform.getCanonicalArchitecture(System.getProperty(I.I(8044)), Platform.isSoftFloat());
        RESOURCE_PREFIX = Platform.getNativeLibraryResourcePrefix();
    }
}

