/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.Function;
import com.sun.jna.FunctionMapper;
import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class NativeLibrary {
    private long handle;
    private final String libraryName;
    private final String libraryPath;
    private final Map functions = new HashMap();
    final int callFlags;
    private String encoding;
    final Map options;
    private static final Map libraries = new HashMap();
    private static final Map searchPaths = Collections.synchronizedMap(new HashMap());
    private static final List librarySearchPath = new ArrayList();
    private static final int DEFAULT_OPEN_OPTIONS = -1;

    private static String functionKey(String string, int n, String string2) {
        return string + I.I(-891) + n + I.I(-891) + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeLibrary(String string, String string2, long l, Map map) {
        int n;
        this.libraryName = this.getLibraryName(string);
        this.libraryPath = string2;
        this.handle = l;
        Object v = map.get(I.I(-1359));
        this.callFlags = n = v instanceof Number ? ((Number)v).intValue() : 0;
        this.options = map;
        this.encoding = (String)map.get(I.I(-929));
        if (this.encoding == null) {
            this.encoding = Native.getDefaultStringEncoding();
        }
        if (Platform.isWindows() && I.I(-913).equals(this.libraryName.toLowerCase())) {
            Map map2 = this.functions;
            synchronized (map2) {
                Function function = new Function(this, I.I(-904), 63, this.encoding){

                    @Override
                    Object invoke(Object[] objectArray, Class clazz, boolean bl, int n) {
                        return Native.getLastError();
                    }

                    @Override
                    Object invoke(Method method, Class[] classArray, Class clazz, Object[] objectArray, Map map) {
                        return Native.getLastError();
                    }
                };
                this.functions.put(NativeLibrary.functionKey(I.I(-904), this.callFlags, this.encoding), function);
            }
        }
    }

    private static int openFlags(Map map) {
        Object v = map.get(I.I(-940));
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeLibrary loadLibrary(String string, Map map) {
        long l;
        Object object;
        block51: {
            List list;
            if (Native.DEBUG_LOAD) {
                System.out.println(I.I(-1262) + string + I.I(-1240));
            }
            boolean bl = new File(string).isAbsolute();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = NativeLibrary.openFlags(map);
            String string2 = Native.getWebStartLibraryPath(string);
            if (string2 != null) {
                if (Native.DEBUG_LOAD) {
                    System.out.println(I.I(-1238) + string2);
                }
                arrayList.add(string2);
            }
            if ((list = (List)searchPaths.get(string)) != null) {
                object = list;
                synchronized (object) {
                    arrayList.addAll(0, list);
                }
            }
            if (Native.DEBUG_LOAD) {
                System.out.println(I.I(-1215) + System.getProperty(I.I(-1178)));
            }
            arrayList.addAll(NativeLibrary.initPaths(I.I(-1178)));
            object = NativeLibrary.findLibraryPath(string, arrayList);
            l = 0L;
            try {
                if (Native.DEBUG_LOAD) {
                    System.out.println(I.I(-1161) + (String)object);
                }
                l = Native.open((String)object, n);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (Native.DEBUG_LOAD) {
                    System.out.println(I.I(-1153) + librarySearchPath);
                }
                arrayList.addAll(librarySearchPath);
            }
            try {
                if (l == 0L) {
                    object = NativeLibrary.findLibraryPath(string, arrayList);
                    if (Native.DEBUG_LOAD) {
                        System.out.println(I.I(-1161) + (String)object);
                    }
                    if ((l = Native.open((String)object, n)) == 0L) {
                        throw new UnsatisfiedLinkError(I.I(-1131) + string + I.I(-1240));
                    }
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                UnsatisfiedLinkError unsatisfiedLinkError2;
                if (Platform.isAndroid()) {
                    try {
                        if (Native.DEBUG_LOAD) {
                            System.out.println(I.I(-1106) + string);
                        }
                        System.loadLibrary(string);
                        l = Native.open((String)object, n);
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
                        unsatisfiedLinkError2 = unsatisfiedLinkError3;
                    }
                } else if (Platform.isLinux() || Platform.isFreeBSD()) {
                    if (Native.DEBUG_LOAD) {
                        System.out.println(I.I(-1072));
                    }
                    if ((object = NativeLibrary.matchLibrary(string, arrayList)) != null) {
                        if (Native.DEBUG_LOAD) {
                            System.out.println(I.I(-1161) + (String)object);
                        }
                        try {
                            l = Native.open((String)object, n);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError4) {
                            unsatisfiedLinkError2 = unsatisfiedLinkError4;
                        }
                    }
                } else if (Platform.isMac() && !string.endsWith(I.I(-32472))) {
                    if (Native.DEBUG_LOAD) {
                        System.out.println(I.I(-1043));
                    }
                    if ((object = NativeLibrary.matchFramework(string)) != null) {
                        try {
                            if (Native.DEBUG_LOAD) {
                                System.out.println(I.I(-1161) + (String)object);
                            }
                            l = Native.open((String)object, n);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError5) {
                            unsatisfiedLinkError2 = unsatisfiedLinkError5;
                        }
                    }
                } else if (Platform.isWindows() && !bl) {
                    if (Native.DEBUG_LOAD) {
                        System.out.println(I.I(-1011));
                    }
                    if ((object = NativeLibrary.findLibraryPath(I.I(-32480) + string, arrayList)) != null) {
                        if (Native.DEBUG_LOAD) {
                            System.out.println(I.I(-1161) + (String)object);
                        }
                        try {
                            l = Native.open((String)object, n);
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError6) {
                            unsatisfiedLinkError2 = unsatisfiedLinkError6;
                        }
                    }
                }
                if (l == 0L) {
                    try {
                        File file = Native.extractFromResourcePath(string, (ClassLoader)map.get(I.I(-1330)));
                        try {
                            l = Native.open(file.getAbsolutePath(), n);
                            object = file.getAbsolutePath();
                        }
                        finally {
                            if (Native.isUnpacked(file)) {
                                Native.deleteLibrary(file);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        unsatisfiedLinkError2 = new UnsatisfiedLinkError(iOException.getMessage());
                    }
                }
                if (l != 0L) break block51;
                throw new UnsatisfiedLinkError(I.I(-987) + string + I.I(-1475) + unsatisfiedLinkError2.getMessage());
            }
        }
        if (Native.DEBUG_LOAD) {
            System.out.println(I.I(-962) + string + I.I(-946) + (String)object);
        }
        return new NativeLibrary(string, (String)object, l, map);
    }

    static String matchFramework(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            if (string.indexOf(I.I(-1314)) != -1 && file.exists()) {
                return file.getAbsolutePath();
            }
            if ((file = new File(new File(file.getParentFile(), file.getName() + I.I(-1314)), file.getName())).exists()) {
                return file.getAbsolutePath();
            }
        } else {
            String[] stringArray = new String[]{System.getProperty(I.I(2573)), "", I.I(-1303)};
            String string2 = string.indexOf(I.I(-1314)) == -1 ? string + I.I(-1295) + string : string;
            for (int j = 0; j < stringArray.length; ++j) {
                String string3 = stringArray[j] + I.I(-1283) + string2;
                if (!new File(string3).exists()) continue;
                return string3;
            }
        }
        return null;
    }

    private String getLibraryName(String string) {
        String string2;
        int n;
        String string3 = string;
        String string4 = I.I(-1318);
        String string5 = NativeLibrary.mapSharedLibraryName(I.I(-1318));
        int n2 = string5.indexOf(I.I(-1318));
        if (n2 > 0 && string3.startsWith(string5.substring(0, n2))) {
            string3 = string3.substring(n2);
        }
        if ((n = string3.indexOf(string2 = string5.substring(n2 + I.I(-1318).length()))) != -1) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    public static final NativeLibrary getInstance(String string) {
        return NativeLibrary.getInstance(string, Collections.emptyMap());
    }

    public static final NativeLibrary getInstance(String string, ClassLoader classLoader) {
        return NativeLibrary.getInstance(string, Collections.singletonMap(I.I(-1330), classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final NativeLibrary getInstance(String string, Map map) {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(map);
        if (hashMap.get(I.I(-1359)) == null) {
            hashMap.put(I.I(-1359), 0);
        }
        if ((Platform.isLinux() || Platform.isFreeBSD() || Platform.isAIX()) && Platform.C_LIBRARY_NAME.equals(string)) {
            string = null;
        }
        Map map2 = libraries;
        synchronized (map2) {
            NativeLibrary nativeLibrary;
            WeakReference<NativeLibrary> weakReference = (WeakReference<NativeLibrary>)libraries.get(string + hashMap);
            NativeLibrary nativeLibrary2 = nativeLibrary = weakReference != null ? (NativeLibrary)weakReference.get() : null;
            if (nativeLibrary == null) {
                nativeLibrary = string == null ? new NativeLibrary(I.I(-1340), null, Native.open(null, NativeLibrary.openFlags(hashMap)), hashMap) : NativeLibrary.loadLibrary(string, hashMap);
                weakReference = new WeakReference<NativeLibrary>(nativeLibrary);
                libraries.put(nativeLibrary.getName() + hashMap, weakReference);
                File file = nativeLibrary.getFile();
                if (file != null) {
                    libraries.put(file.getAbsolutePath() + hashMap, weakReference);
                    libraries.put(file.getName() + hashMap, weakReference);
                }
            }
            return nativeLibrary;
        }
    }

    public static final synchronized NativeLibrary getProcess() {
        return NativeLibrary.getInstance(null);
    }

    public static final synchronized NativeLibrary getProcess(Map map) {
        return NativeLibrary.getInstance(null, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addSearchPath(String string, String string2) {
        Map map = searchPaths;
        synchronized (map) {
            List<String> list = (List<String>)searchPaths.get(string);
            if (list == null) {
                list = Collections.synchronizedList(new ArrayList());
                searchPaths.put(string, list);
            }
            list.add(string2);
        }
    }

    public Function getFunction(String string) {
        return this.getFunction(string, this.callFlags);
    }

    Function getFunction(String string, Method method) {
        String string2;
        FunctionMapper functionMapper = (FunctionMapper)this.options.get(I.I(-1441));
        if (functionMapper != null) {
            string = functionMapper.getFunctionName(this, method);
        }
        if (string.startsWith(string2 = System.getProperty(I.I(-1425), I.I(-1405)))) {
            string = string.substring(string2.length());
        }
        int n = this.callFlags;
        Class<?>[] classArray = method.getExceptionTypes();
        for (int j = 0; j < classArray.length; ++j) {
            if (!LastErrorException.class.isAssignableFrom(classArray[j])) continue;
            n |= 0x40;
        }
        return this.getFunction(string, n);
    }

    public Function getFunction(String string, int n) {
        return this.getFunction(string, n, this.encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function getFunction(String string, int n, String string2) {
        if (string == null) {
            throw new NullPointerException(I.I(-1471));
        }
        Map map = this.functions;
        synchronized (map) {
            String string3 = NativeLibrary.functionKey(string, n, string2);
            Function function = (Function)this.functions.get(string3);
            if (function == null) {
                function = new Function(this, string, n, string2);
                this.functions.put(string3, function);
            }
            return function;
        }
    }

    public Map getOptions() {
        return this.options;
    }

    public Pointer getGlobalVariableAddress(String string) {
        try {
            return new Pointer(this.getSymbolAddress(string));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new UnsatisfiedLinkError(I.I(-1494) + string + I.I(-1475) + unsatisfiedLinkError.getMessage());
        }
    }

    long getSymbolAddress(String string) {
        if (this.handle == 0L) {
            throw new UnsatisfiedLinkError(I.I(-1520));
        }
        return Native.findSymbol(this.handle, string);
    }

    public String toString() {
        return I.I(-1539) + this.libraryPath + I.I(-1522) + this.handle + I.I(17267);
    }

    public String getName() {
        return this.libraryName;
    }

    public File getFile() {
        if (this.libraryPath == null) {
            return null;
        }
        return new File(this.libraryPath);
    }

    protected void finalize() {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeAll() {
        LinkedHashSet linkedHashSet;
        Map map = libraries;
        synchronized (map) {
            linkedHashSet = new LinkedHashSet(libraries.values());
        }
        for (Reference reference : linkedHashSet) {
            NativeLibrary nativeLibrary = (NativeLibrary)reference.get();
            if (nativeLibrary == null) continue;
            nativeLibrary.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashSet hashSet = new HashSet();
        Object object = libraries;
        synchronized (object) {
            for (Map.Entry entry : libraries.entrySet()) {
                Reference reference = (Reference)entry.getValue();
                if (reference.get() != this) continue;
                hashSet.add(entry.getKey());
            }
            for (Map.Entry entry : hashSet) {
                libraries.remove(entry);
            }
        }
        object = this;
        synchronized (object) {
            if (this.handle != 0L) {
                Native.close(this.handle);
                this.handle = 0L;
            }
        }
    }

    private static List initPaths(String string) {
        String string2 = System.getProperty(string, "");
        if ("".equals(string2)) {
            return Collections.emptyList();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if ("".equals(string3)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static String findLibraryPath(String string, List list) {
        if (new File(string).isAbsolute()) {
            return string;
        }
        String string2 = NativeLibrary.mapSharedLibraryName(string);
        for (String string3 : list) {
            File file = new File(string3, string2);
            if (file.exists()) {
                return file.getAbsolutePath();
            }
            if (!Platform.isMac() || !string2.endsWith(I.I(-32472)) || !(file = new File(string3, string2.substring(0, string2.lastIndexOf(I.I(-32472))) + I.I(-1552))).exists()) continue;
            return file.getAbsolutePath();
        }
        return string2;
    }

    static String mapSharedLibraryName(String string) {
        if (Platform.isMac()) {
            if (string.startsWith(I.I(-32480)) && (string.endsWith(I.I(-32472)) || string.endsWith(I.I(-1552)))) {
                return string;
            }
            String string2 = System.mapLibraryName(string);
            if (string2.endsWith(I.I(-1552))) {
                return string2.substring(0, string2.lastIndexOf(I.I(-1552))) + I.I(-32472);
            }
            return string2;
        }
        if (Platform.isLinux() || Platform.isFreeBSD() ? NativeLibrary.isVersionedName(string) || string.endsWith(I.I(-32476)) : (Platform.isAIX() ? string.startsWith(I.I(-32480)) : Platform.isWindows() && (string.endsWith(I.I(-1544)) || string.endsWith(I.I(-32485))))) {
            return string;
        }
        return System.mapLibraryName(string);
    }

    private static boolean isVersionedName(String string) {
        int n;
        if (string.startsWith(I.I(-32480)) && (n = string.lastIndexOf(I.I(-1557))) != -1 && n + 4 < string.length()) {
            for (int j = n + 4; j < string.length(); ++j) {
                char c = string.charAt(j);
                if (Character.isDigit(c) || c == '.') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static String matchLibrary(final String string, List list) {
        Object object;
        File file = new File(string);
        if (file.isAbsolute()) {
            list = Arrays.asList(file.getParent());
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return (string2.startsWith(I.I(-32480) + string + I.I(-32476)) || string2.startsWith(string + I.I(-32476)) && string.startsWith(I.I(-32480))) && NativeLibrary.isVersionedName(string2);
            }
        };
        LinkedList<File> linkedList = new LinkedList<File>();
        for (String string2 : list) {
            object = new File(string2).listFiles(filenameFilter);
            if (object == null || ((File[])object).length <= 0) continue;
            linkedList.addAll(Arrays.asList(object));
        }
        double d = -1.0;
        object = null;
        for (File file2 : linkedList) {
            String string3 = file2.getAbsolutePath();
            String string4 = string3.substring(string3.lastIndexOf(I.I(-1557)) + 4);
            double d2 = NativeLibrary.parseVersion(string4);
            if (!(d2 > d)) continue;
            d = d2;
            object = string3;
        }
        return object;
    }

    static double parseVersion(String string) {
        double d = 0.0;
        double d2 = 1.0;
        int n = string.indexOf(I.I(1448));
        while (string != null) {
            String string2;
            if (n != -1) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
                n = string.indexOf(I.I(1448));
            } else {
                string2 = string;
                string = null;
            }
            try {
                d += (double)Integer.parseInt(string2) / d2;
            }
            catch (NumberFormatException numberFormatException) {
                return 0.0;
            }
            d2 *= 100.0;
        }
        return d;
    }

    private static String getMultiArchPath() {
        String string = Platform.ARCH;
        String string2 = Platform.iskFreeBSD() ? I.I(-1588) : (Platform.isGNU() ? "" : I.I(-1578));
        String string3 = I.I(-1571);
        if (Platform.isIntel()) {
            string = Platform.is64Bit() ? I.I(20173) : I.I(31956);
        } else if (Platform.isPPC()) {
            string = Platform.is64Bit() ? I.I(-1927) : I.I(-1935);
        } else if (Platform.isARM()) {
            string = I.I(-2045);
            string3 = I.I(-1566);
        }
        return string + string2 + string3;
    }

    private static ArrayList getLinuxLdPaths() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(I.I(-1611));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string = "";
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                int n = string.indexOf(I.I(-1593));
                int n2 = string.lastIndexOf(47);
                if (n == -1 || n2 == -1 || n >= n2 || arrayList.contains(string2 = string.substring(n + 4, n2))) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    static {
        if (Native.POINTER_SIZE == 0) {
            throw new Error(I.I(-1710));
        }
        String string = Native.getWebStartLibraryPath(I.I(-1679));
        if (string != null) {
            librarySearchPath.add(string);
        }
        if (System.getProperty(I.I(-1667)) == null && !Platform.isWindows()) {
            Object object;
            String string2 = "";
            String string3 = "";
            String string4 = "";
            if (Platform.isLinux() || Platform.isSolaris() || Platform.isFreeBSD() || Platform.iskFreeBSD()) {
                string4 = (Platform.isSolaris() ? I.I(1843) : "") + Pointer.SIZE * 8;
            }
            String[] stringArray = new String[]{I.I(-1641) + string4, I.I(-1632) + string4, I.I(-1641), I.I(-1632)};
            if (Platform.isLinux() || Platform.iskFreeBSD() || Platform.isGNU()) {
                object = NativeLibrary.getMultiArchPath();
                stringArray = new String[]{I.I(-1627) + (String)object, I.I(-1617) + (String)object, I.I(-1641) + string4, I.I(-1632) + string4, I.I(-1641), I.I(-1632)};
            }
            if (Platform.isLinux()) {
                object = NativeLibrary.getLinuxLdPaths();
                for (int j = stringArray.length - 1; 0 <= j; --j) {
                    int n = ((ArrayList)object).indexOf(stringArray[j]);
                    if (n != -1) {
                        ((ArrayList)object).remove(n);
                    }
                    ((ArrayList)object).add(0, stringArray[j]);
                }
                stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                File file = new File(stringArray[j]);
                if (!file.exists() || !file.isDirectory()) continue;
                string2 = string2 + string3 + stringArray[j];
                string3 = File.pathSeparator;
            }
            if (!"".equals(string2)) {
                System.setProperty(I.I(-1667), string2);
            }
        }
        librarySearchPath.addAll(NativeLibrary.initPaths(I.I(-1667)));
    }
}

