/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.MethodResultContext;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Version;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public final class Native
implements Version {
    public static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    public static boolean DEBUG_LOAD = Boolean.getBoolean(I.I(-2663));
    public static boolean DEBUG_JNA_LOAD = Boolean.getBoolean(I.I(-2648));
    static String jnidispatchPath = null;
    private static final Map typeOptions = new WeakHashMap();
    private static final Map libraries = new WeakHashMap();
    private static final String _OPTION_ENCLOSING_LIBRARY = "enclosing-library";
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    public static final int BOOL_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;
    private static final int TYPE_BOOL = 4;
    static final int MAX_ALIGNMENT;
    static final int MAX_PADDING;
    private static final Object finalizer;
    static final String JNA_TMPLIB_PREFIX = "jna";
    private static Map registeredClasses;
    private static Map registeredLibraries;
    static final int CB_HAS_INITIALIZER = 1;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_POINTER = 1;
    private static final int CVT_STRING = 2;
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_BYTE = 6;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int CVT_ARRAY_INT = 9;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_FLOAT = 11;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_FLOAT = 16;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_NATIVE_MAPPED_STRING = 18;
    private static final int CVT_NATIVE_MAPPED_WSTRING = 19;
    private static final int CVT_WSTRING = 20;
    private static final int CVT_INTEGER_TYPE = 21;
    private static final int CVT_POINTER_TYPE = 22;
    private static final int CVT_TYPE_MAPPER = 23;
    private static final int CVT_TYPE_MAPPER_STRING = 24;
    private static final int CVT_TYPE_MAPPER_WSTRING = 25;
    static final int CB_OPTION_DIRECT = 1;
    static final int CB_OPTION_IN_DLL = 2;
    private static final ThreadLocal nativeThreadTerminationFlag;
    private static final Map nativeThreads;

    public static float parseVersion(String string) {
        return Float.parseFloat(string.substring(0, string.lastIndexOf(I.I(1448))));
    }

    static boolean isCompatibleVersion(String string, String string2) {
        String[] stringArray = string.split(I.I(67973));
        String[] stringArray2 = string2.split(I.I(67973));
        if (stringArray.length < 3 || stringArray2.length < 3) {
            return false;
        }
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray2[0]);
        int n3 = Integer.parseInt(stringArray[1]);
        int n4 = Integer.parseInt(stringArray2[1]);
        if (n != n2) {
            return false;
        }
        return n3 <= n4;
    }

    private static void dispose() {
        CallbackReference.disposeAll();
        Memory.disposeAll();
        NativeLibrary.disposeAll();
        Native.unregisterAll();
        jnidispatchPath = null;
        System.setProperty(I.I(-2216), I.I(67967));
    }

    static boolean deleteLibrary(File file) {
        if (file.delete()) {
            return true;
        }
        Native.markTemporaryFile(file);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static void setPreserveLastError(boolean bl) {
    }

    public static boolean getPreserveLastError() {
        return true;
    }

    public static long getWindowID(Window window) throws HeadlessException {
        return AWT.getWindowID(window);
    }

    public static long getComponentID(Component component) throws HeadlessException {
        return AWT.getComponentID(component);
    }

    public static Pointer getWindowPointer(Window window) throws HeadlessException {
        return new Pointer(AWT.getWindowID(window));
    }

    public static Pointer getComponentPointer(Component component) throws HeadlessException {
        return new Pointer(AWT.getComponentID(component));
    }

    static native long getWindowHandle0(Component var0);

    public static Pointer getDirectBufferPointer(Buffer buffer) {
        long l = Native._getDirectBufferPointer(buffer);
        return l == 0L ? null : new Pointer(l);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] byArray) {
        return Native.toString(byArray, Native.getDefaultStringEncoding());
    }

    public static String toString(byte[] byArray, String string) {
        int n = byArray.length;
        for (int j = 0; j < n; ++j) {
            if (byArray[j] != 0) continue;
            n = j;
            break;
        }
        if (n == 0) {
            return "";
        }
        if (string != null) {
            try {
                return new String(byArray, 0, n, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(I.I(67564) + string + I.I(67588));
            }
        }
        System.err.println(I.I(67930) + System.getProperty(I.I(67642)));
        return new String(byArray, 0, n);
    }

    public static String toString(char[] cArray) {
        int n = cArray.length;
        for (int j = 0; j < n; ++j) {
            if (cArray[j] != '\u0000') continue;
            n = j;
            break;
        }
        if (n == 0) {
            return "";
        }
        return new String(cArray, 0, n);
    }

    public static List toStringList(char[] cArray) {
        return Native.toStringList(cArray, 0, cArray.length);
    }

    public static List toStringList(char[] cArray, int n, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        int n4 = n + n2;
        for (int j = n; j < n4; ++j) {
            if (cArray[j] != '\u0000') continue;
            if (n3 == j) {
                return arrayList;
            }
            String string = new String(cArray, n3, j - n3);
            arrayList.add(string);
            n3 = j + 1;
        }
        if (n3 < n4) {
            String string = new String(cArray, n3, n4 - n3);
            arrayList.add(string);
        }
        return arrayList;
    }

    public static Object loadLibrary(Class clazz) {
        return Native.loadLibrary(null, clazz);
    }

    public static Object loadLibrary(Class clazz, Map map) {
        return Native.loadLibrary(null, clazz, map);
    }

    public static Object loadLibrary(String string, Class clazz) {
        return Native.loadLibrary(string, clazz, Collections.emptyMap());
    }

    public static Object loadLibrary(String string, Class clazz, Map map) {
        if (!Library.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(I.I(67886) + clazz.getSimpleName() + I.I(67898) + string + I.I(67912) + Library.class.getSimpleName());
        }
        Library.Handler handler = new Library.Handler(string, clazz, map);
        ClassLoader classLoader = clazz.getClassLoader();
        Object object = Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)handler);
        Native.cacheOptions(clazz, map, object);
        return clazz.cast(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryInstance(Class clazz) {
        Map map = libraries;
        synchronized (map) {
            if (clazz != null && !libraries.containsKey(clazz)) {
                try {
                    Field[] fieldArray = clazz.getFields();
                    for (int j = 0; j < fieldArray.length; ++j) {
                        Field field = fieldArray[j];
                        if (field.getType() != clazz || !Modifier.isStatic(field.getModifiers())) continue;
                        libraries.put(clazz, new WeakReference<Object>(field.get(null)));
                        break;
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException(I.I(67856) + clazz + I.I(16661) + exception + I.I(16664));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class clazz) {
        Class clazz2;
        if (clazz == null) {
            return null;
        }
        Object object = libraries;
        synchronized (object) {
            if (typeOptions.containsKey(clazz)) {
                Map map = (Map)typeOptions.get(clazz);
                Class clazz3 = (Class)map.get(I.I(66183));
                if (clazz3 != null) {
                    return clazz3;
                }
                return clazz;
            }
        }
        if (Library.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            clazz = CallbackReference.findCallbackClass(clazz);
        }
        if ((clazz2 = Native.findEnclosingLibraryClass((Class)(object = clazz.getDeclaringClass()))) != null) {
            return clazz2;
        }
        return Native.findEnclosingLibraryClass(clazz.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class clazz) {
        Map map;
        Object object = libraries;
        synchronized (object) {
            map = (Map)typeOptions.get(clazz);
            if (map != null) {
                return map;
            }
        }
        object = Native.findEnclosingLibraryClass(clazz);
        if (object != null) {
            Native.loadLibraryInstance((Class)object);
        } else {
            object = clazz;
        }
        Map map2 = libraries;
        synchronized (map2) {
            map = (Map)typeOptions.get(object);
            if (map != null) {
                typeOptions.put(clazz, map);
                return map;
            }
            try {
                Field field = ((Class)object).getField(I.I(67726));
                field.setAccessible(true);
                map = (Map)field.get(null);
                if (map == null) {
                    throw new IllegalStateException(I.I(67734));
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                map = Collections.emptyMap();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(I.I(67753) + exception + I.I(67722) + object);
            }
            map = new HashMap(map);
            if (!map.containsKey(I.I(65930))) {
                map.put(I.I(65930), Native.lookupField((Class)object, I.I(67808), TypeMapper.class));
            }
            if (!map.containsKey(I.I(67656))) {
                map.put(I.I(67656), Native.lookupField((Class)object, I.I(67820), Integer.class));
            }
            if (!map.containsKey(I.I(-929))) {
                map.put(I.I(-929), Native.lookupField((Class)object, I.I(67840), String.class));
            }
            map = Native.cacheOptions((Class)object, map, null);
            if (clazz != object) {
                typeOptions.put(clazz, map);
            }
            return map;
        }
    }

    private static Object lookupField(Class clazz, String string, Class clazz2) {
        try {
            Field field = clazz.getField(string);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string + I.I(67689) + clazz2.getName() + I.I(16661) + exception + I.I(67722) + clazz);
        }
    }

    public static TypeMapper getTypeMapper(Class clazz) {
        Map map = Native.getLibraryOptions(clazz);
        return (TypeMapper)map.get(I.I(65930));
    }

    public static String getStringEncoding(Class clazz) {
        Map map = Native.getLibraryOptions(clazz);
        String string = (String)map.get(I.I(-929));
        return string != null ? string : Native.getDefaultStringEncoding();
    }

    public static String getDefaultStringEncoding() {
        return System.getProperty(I.I(67676), DEFAULT_ENCODING);
    }

    public static int getStructureAlignment(Class clazz) {
        Integer n = (Integer)Native.getLibraryOptions(clazz).get(I.I(67656));
        return n == null ? 0 : n;
    }

    static byte[] getBytes(String string) {
        return Native.getBytes(string, Native.getDefaultStringEncoding());
    }

    static byte[] getBytes(String string, String string2) {
        if (string2 != null) {
            try {
                return string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(I.I(67564) + string2 + I.I(67588));
            }
        }
        System.err.println(I.I(67605) + System.getProperty(I.I(67642)));
        return string.getBytes();
    }

    public static byte[] toByteArray(String string) {
        return Native.toByteArray(string, Native.getDefaultStringEncoding());
    }

    public static byte[] toByteArray(String string, String string2) {
        byte[] byArray = Native.getBytes(string, string2);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static char[] toCharArray(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private static void loadNativeDispatchLibrary() {
        if (!Boolean.getBoolean(I.I(-2179))) {
            try {
                Native.removeTemporaryFiles();
            }
            catch (IOException iOException) {
                System.err.println(I.I(67291) + iOException.getMessage());
            }
        }
        String string = System.getProperty(I.I(67343), I.I(-1679));
        String string2 = System.getProperty(I.I(67365));
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4;
                String string5 = stringTokenizer.nextToken();
                File file = new File(new File(string5), System.mapLibraryName(string).replace(I.I(-32472), I.I(-1552)));
                String string6 = file.getAbsolutePath();
                if (DEBUG_JNA_LOAD) {
                    System.out.println(I.I(67048) + string6);
                }
                if (file.exists()) {
                    try {
                        if (DEBUG_JNA_LOAD) {
                            System.out.println(I.I(-1161) + string6);
                        }
                        System.setProperty(I.I(67252), string6);
                        System.load(string6);
                        jnidispatchPath = string6;
                        if (DEBUG_JNA_LOAD) {
                            System.out.println(I.I(67269) + string6);
                        }
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
                if (!Platform.isMac()) continue;
                if (string6.endsWith(I.I(67387))) {
                    string4 = I.I(67387);
                    string3 = I.I(67393);
                } else {
                    string4 = I.I(67393);
                    string3 = I.I(67387);
                }
                string6 = string6.substring(0, string6.lastIndexOf(string4)) + string3;
                if (DEBUG_JNA_LOAD) {
                    System.out.println(I.I(67048) + string6);
                }
                if (!new File(string6).exists()) continue;
                try {
                    if (DEBUG_JNA_LOAD) {
                        System.out.println(I.I(-1161) + string6);
                    }
                    System.setProperty(I.I(67252), string6);
                    System.load(string6);
                    jnidispatchPath = string6;
                    if (DEBUG_JNA_LOAD) {
                        System.out.println(I.I(67269) + string6);
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.err.println(I.I(67400) + string6 + I.I(67415) + unsatisfiedLinkError.getMessage());
                }
            }
        }
        if (!Boolean.getBoolean(I.I(67435))) {
            try {
                if (DEBUG_JNA_LOAD) {
                    System.out.println(I.I(67445) + string);
                }
                System.loadLibrary(string);
                if (DEBUG_JNA_LOAD) {
                    System.out.println(I.I(67471));
                }
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (Boolean.getBoolean(I.I(67504))) {
            throw new UnsatisfiedLinkError(I.I(67520));
        }
        Native.loadNativeDispatchLibraryFromClasspath();
    }

    private static void loadNativeDispatchLibraryFromClasspath() {
        try {
            String string = I.I(67204) + Platform.RESOURCE_PREFIX + I.I(1843) + System.mapLibraryName(I.I(-1679)).replace(I.I(-32472), I.I(-1552));
            File file = Native.extractFromResourcePath(string, Native.class.getClassLoader());
            if (file == null && file == null) {
                throw new UnsatisfiedLinkError(I.I(67218));
            }
            if (DEBUG_JNA_LOAD) {
                System.out.println(I.I(-1161) + file.getAbsolutePath());
            }
            System.setProperty(I.I(67252), file.getAbsolutePath());
            System.load(file.getAbsolutePath());
            jnidispatchPath = file.getAbsolutePath();
            if (DEBUG_JNA_LOAD) {
                System.out.println(I.I(67269) + jnidispatchPath);
            }
            if (Native.isUnpacked(file) && !Boolean.getBoolean(I.I(67135))) {
                Native.deleteLibrary(file);
            }
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(iOException.getMessage());
        }
    }

    static boolean isUnpacked(File file) {
        return file.getName().startsWith(I.I(67131));
    }

    public static File extractFromResourcePath(String string) throws IOException {
        return Native.extractFromResourcePath(string, null);
    }

    public static File extractFromResourcePath(String string, ClassLoader classLoader) throws IOException {
        URL uRL;
        String string2;
        boolean bl;
        boolean bl2 = bl = DEBUG_LOAD || DEBUG_JNA_LOAD && string.indexOf(I.I(-1679)) != -1;
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = Native.class.getClassLoader();
        }
        if (bl) {
            System.out.println(I.I(66919) + classLoader + I.I(66946) + string);
        }
        String string3 = string.startsWith(I.I(1843)) ? string : NativeLibrary.mapSharedLibraryName(string);
        String string4 = string2 = string.startsWith(I.I(1843)) ? string : Platform.RESOURCE_PREFIX + I.I(1843) + string3;
        if (string2.startsWith(I.I(1843))) {
            string2 = string2.substring(1);
        }
        if ((uRL = classLoader.getResource(string2)) == null && string2.startsWith(Platform.RESOURCE_PREFIX)) {
            uRL = classLoader.getResource(string3);
        }
        if (uRL == null) {
            String string5 = System.getProperty(I.I(66952));
            if (classLoader instanceof URLClassLoader) {
                string5 = Arrays.asList(((URLClassLoader)classLoader).getURLs()).toString();
            }
            throw new IOException(I.I(66968) + string2 + I.I(66985) + string5 + I.I(16664));
        }
        if (bl) {
            System.out.println(I.I(67016) + uRL);
        }
        File file = null;
        if (uRL.getProtocol().toLowerCase().equals(I.I(67043))) {
            try {
                file = new File(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (bl) {
                System.out.println(I.I(67048) + file.getAbsolutePath());
            }
            if (!file.exists()) {
                throw new IOException(I.I(67060) + uRL + I.I(67070));
            }
        } else if (!Boolean.getBoolean(I.I(-2179))) {
            InputStream inputStream = classLoader.getResourceAsStream(string2);
            if (inputStream == null) {
                throw new IOException(I.I(67101) + string2);
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                File file2 = Native.getTempDir();
                file = File.createTempFile(I.I(67131), Platform.isWindows() ? I.I(-32485) : null, file2);
                if (!Boolean.getBoolean(I.I(67135))) {
                    file.deleteOnExit();
                }
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new IOException(I.I(67156) + string + I.I(67193) + iOException.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return file;
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static native int getLastError();

    public static native void setLastError(int var0);

    public static Library synchronizedLibrary(final Library library) {
        Class<?> clazz = library.getClass();
        if (!Proxy.isProxyClass(clazz)) {
            throw new IllegalArgumentException(I.I(66860));
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(library);
        if (!(invocationHandler instanceof Library.Handler)) {
            throw new IllegalArgumentException(I.I(66890) + invocationHandler);
        }
        final Library.Handler handler = (Library.Handler)invocationHandler;
        InvocationHandler invocationHandler2 = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method, objectArray);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), invocationHandler2);
    }

    public static String getWebStartLibraryPath(String string) {
        if (System.getProperty(I.I(66839)) == null) {
            return null;
        }
        try {
            ClassLoader classLoader = Native.class.getClassLoader();
            Method method = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Method run() {
                    try {
                        Method method = ClassLoader.class.getDeclaredMethod(I.I(68048), String.class);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            String string2 = (String)method.invoke((Object)classLoader, string);
            if (string2 != null) {
                return new File(string2).getParent();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        try {
            File file2 = new File(file.getParentFile(), file.getName() + I.I(66836));
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static File getTempDir() throws IOException {
        File file;
        String string = System.getProperty(I.I(66734));
        if (string != null) {
            file = new File(string);
            file.mkdirs();
        } else {
            File file2 = new File(System.getProperty(I.I(66745)));
            file = new File(file2, I.I(66760) + System.getProperty(I.I(66765)).hashCode());
            file.mkdirs();
            if (!file.exists() || !file.canWrite()) {
                file = file2;
            }
        }
        if (!file.exists()) {
            throw new IOException(I.I(66775) + file + I.I(66801));
        }
        if (!file.canWrite()) {
            throw new IOException(I.I(66775) + file + I.I(66818));
        }
        return file;
    }

    static void removeTemporaryFiles() throws IOException {
        File file = Native.getTempDir();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(I.I(66836)) && string.startsWith(I.I(67131));
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int j = 0; fileArray != null && j < fileArray.length; ++j) {
            File file2 = fileArray[j];
            String string = file2.getName();
            string = string.substring(0, string.length() - 2);
            File file3 = new File(file2.getParentFile(), string);
            if (file3.exists() && !file3.delete()) continue;
            file2.delete();
        }
    }

    public static int getNativeSize(Class clazz, Object object) {
        if (clazz.isArray()) {
            int n = Array.getLength(object);
            if (n > 0) {
                Object object2 = Array.get(object, 0);
                return n * Native.getNativeSize(clazz.getComponentType(), object2);
            }
            throw new IllegalArgumentException(I.I(66666) + clazz);
        }
        if (Structure.class.isAssignableFrom(clazz) && !Structure.ByReference.class.isAssignableFrom(clazz)) {
            return Structure.size(clazz, (Structure)object);
        }
        try {
            return Native.getNativeSize(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(I.I(66702) + clazz.getName() + I.I(66713) + illegalArgumentException.getMessage());
        }
    }

    public static int getNativeSize(Class clazz) {
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            clazz = NativeMappedConverter.getInstance(clazz).nativeType();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return 4;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return 1;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return 2;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return WCHAR_SIZE;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 8;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return 4;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return Structure.size(clazz);
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffers.isBuffer(clazz) || Callback.class.isAssignableFrom(clazz) || String.class == clazz || WString.class == clazz) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException(I.I(66630) + clazz.getName() + I.I(66653));
    }

    public static boolean isSupportedNativeType(Class clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            return Native.getNativeSize(clazz) != 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler uncaughtExceptionHandler) {
        callbackExceptionHandler = uncaughtExceptionHandler == null ? DEFAULT_HANDLER : uncaughtExceptionHandler;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String string) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), string);
    }

    public static void register(NativeLibrary nativeLibrary) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), nativeLibrary);
    }

    static Class findDirectMappedClass(Class clazz) {
        Method[] methodArray;
        for (Method method : methodArray = clazz.getDeclaredMethods()) {
            if ((method.getModifiers() & 0x100) == 0) continue;
            return clazz;
        }
        int n = clazz.getName().lastIndexOf(I.I(66559));
        if (n != -1) {
            String string = clazz.getName().substring(0, n);
            try {
                return Native.findDirectMappedClass(Class.forName(string, true, clazz.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException(I.I(66561) + clazz + I.I(16664));
    }

    static Class getCallingClass() {
        Class[] classArray = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classArray == null) {
            throw new IllegalStateException(I.I(66380));
        }
        if (classArray.length < 4) {
            throw new IllegalStateException(I.I(66493));
        }
        return classArray[3];
    }

    public static void setCallbackThreadInitializer(Callback callback, CallbackThreadInitializer callbackThreadInitializer) {
        CallbackReference.setCallbackThreadInitializer(callback, callbackThreadInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unregisterAll() {
        Map map = registeredClasses;
        synchronized (map) {
            for (Map.Entry entry : registeredClasses.entrySet()) {
                Native.unregister((Class)entry.getKey(), (long[])entry.getValue());
            }
            registeredClasses.clear();
        }
    }

    public static void unregister() {
        Native.unregister(Native.findDirectMappedClass(Native.getCallingClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class clazz) {
        Map map = registeredClasses;
        synchronized (map) {
            long[] lArray = (long[])registeredClasses.get(clazz);
            if (lArray != null) {
                Native.unregister(clazz, lArray);
                registeredClasses.remove(clazz);
                registeredLibraries.remove(clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registered(Class clazz) {
        Map map = registeredClasses;
        synchronized (map) {
            return registeredClasses.containsKey(clazz);
        }
    }

    private static native void unregister(Class var0, long[] var1);

    static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            return I.I(17067) + Native.getSignature(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return I.I(66376);
            }
            if (clazz == Boolean.TYPE) {
                return I.I(18508);
            }
            if (clazz == Byte.TYPE) {
                return I.I(18500);
            }
            if (clazz == Short.TYPE) {
                return I.I(18504);
            }
            if (clazz == Character.TYPE) {
                return I.I(18514);
            }
            if (clazz == Integer.TYPE) {
                return I.I(18502);
            }
            if (clazz == Long.TYPE) {
                return I.I(18506);
            }
            if (clazz == Float.TYPE) {
                return I.I(18510);
            }
            if (clazz == Double.TYPE) {
                return I.I(18512);
            }
        }
        return I.I(66378) + Native.replace(I.I(1448), I.I(1843), clazz.getName()) + I.I(21765);
    }

    static String replace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n;
            if ((n = string3.indexOf(string)) == -1) break;
            stringBuilder.append(string3.substring(0, n));
            stringBuilder.append(string2);
            string3 = string3.substring(n + string.length());
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    private static int getConversion(Class clazz, TypeMapper typeMapper) {
        Object object;
        if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        } else if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        } else if (clazz == Short.class) {
            clazz = Short.TYPE;
        } else if (clazz == Character.class) {
            clazz = Character.TYPE;
        } else if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Long.class) {
            clazz = Long.TYPE;
        } else if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Double.class) {
            clazz = Double.TYPE;
        } else if (clazz == Void.class) {
            clazz = Void.TYPE;
        }
        if (typeMapper != null) {
            object = typeMapper.getFromNativeConverter(clazz);
            ToNativeConverter toNativeConverter = typeMapper.getToNativeConverter(clazz);
            if (object != null) {
                Class clazz2 = object.nativeType();
                if (clazz2 == String.class) {
                    return 24;
                }
                if (clazz2 == WString.class) {
                    return 25;
                }
                return 23;
            }
            if (toNativeConverter != null) {
                Class clazz3 = toNativeConverter.nativeType();
                if (clazz3 == String.class) {
                    return 24;
                }
                if (clazz3 == WString.class) {
                    return 25;
                }
                return 23;
            }
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (String.class == clazz) {
            return 2;
        }
        if (WString.class.isAssignableFrom(clazz)) {
            return 20;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(clazz)) {
            return 5;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return 4;
            }
            return 3;
        }
        if (clazz.isArray()) {
            switch (clazz.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (clazz.isPrimitive()) {
            return clazz == Boolean.TYPE ? 14 : 0;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (IntegerType.class.isAssignableFrom(clazz)) {
            return 21;
        }
        if (PointerType.class.isAssignableFrom(clazz)) {
            return 22;
        }
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            object = NativeMappedConverter.getInstance(clazz).nativeType();
            if (object == String.class) {
                return 18;
            }
            if (object == WString.class) {
                return 19;
            }
            return 17;
        }
        return -1;
    }

    public static void register(Class clazz, String string) {
        NativeLibrary nativeLibrary = NativeLibrary.getInstance(string, Collections.singletonMap(I.I(-1330), clazz.getClassLoader()));
        Native.register(clazz, nativeLibrary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void register(Class clazz, NativeLibrary nativeLibrary) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Map map = nativeLibrary.getOptions();
        TypeMapper typeMapper = (TypeMapper)map.get(I.I(65930));
        map = Native.cacheOptions(clazz, map, null);
        Method[] objectArray = methodArray;
        int map2 = objectArray.length;
        for (int method = 0; method < map2; ++method) {
            Method method2 = objectArray[method];
            if ((method2.getModifiers() & 0x100) == 0) continue;
            arrayList.add(method2);
        }
        long[] lArray = new long[arrayList.size()];
        for (map2 = 0; map2 < lArray.length; ++map2) {
            void var9_15;
            Class<Pointer> clazz2;
            long l;
            long l2;
            Method method = (Method)arrayList.get(map2);
            String string = I.I(-1736);
            Class<?> clazz3 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            long[] lArray2 = new long[classArray.length];
            long[] lArray3 = new long[classArray.length];
            int[] nArray = new int[classArray.length];
            ToNativeConverter[] toNativeConverterArray = new ToNativeConverter[classArray.length];
            FromNativeConverter fromNativeConverter = null;
            int n = Native.getConversion(clazz3, typeMapper);
            boolean bl = false;
            switch (n) {
                case -1: {
                    throw new IllegalArgumentException(clazz3 + I.I(66201) + method.getName() + I.I(66245) + clazz + I.I(16664));
                }
                case 23: 
                case 24: 
                case 25: {
                    fromNativeConverter = typeMapper.getFromNativeConverter(clazz3);
                    l2 = Structure.FFIType.get(clazz3.isPrimitive() ? clazz3 : Pointer.class).peer;
                    l = Structure.FFIType.get((Object)fromNativeConverter.nativeType()).peer;
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 21: 
                case 22: {
                    l2 = Structure.FFIType.get(Pointer.class).peer;
                    l = Structure.FFIType.get((Object)NativeMappedConverter.getInstance(clazz3).nativeType()).peer;
                    break;
                }
                case 3: {
                    l2 = l = Structure.FFIType.get(Pointer.class).peer;
                    break;
                }
                case 4: {
                    l2 = Structure.FFIType.get(Pointer.class).peer;
                    l = Structure.FFIType.get(clazz3).peer;
                    break;
                }
                default: {
                    l2 = l = Structure.FFIType.get(clazz3).peer;
                }
            }
            block19: for (int j = 0; j < classArray.length; ++j) {
                int n2;
                clazz2 = classArray[j];
                String string2 = (String)var9_15 + Native.getSignature(clazz2);
                nArray[j] = n2 = Native.getConversion(clazz2, typeMapper);
                if (n2 == -1) {
                    throw new IllegalArgumentException(clazz2 + I.I(66250) + method.getName() + I.I(66245) + clazz + I.I(16664));
                }
                if (n2 == 17 || n2 == 18 || n2 == 19 || n2 == 21) {
                    clazz2 = NativeMappedConverter.getInstance(clazz2).nativeType();
                } else if (n2 == 23 || n2 == 24 || n2 == 25) {
                    toNativeConverterArray[j] = typeMapper.getToNativeConverter(clazz2);
                }
                switch (n2) {
                    case 4: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 21: 
                    case 22: {
                        lArray2[j] = Structure.FFIType.get((Object)clazz2).peer;
                        lArray3[j] = Structure.FFIType.get(Pointer.class).peer;
                        continue block19;
                    }
                    case 23: 
                    case 24: 
                    case 25: {
                        lArray3[j] = Structure.FFIType.get(clazz2.isPrimitive() ? clazz2 : Pointer.class).peer;
                        lArray2[j] = Structure.FFIType.get((Object)toNativeConverterArray[j].nativeType()).peer;
                        continue block19;
                    }
                    case 0: {
                        lArray3[j] = lArray2[j] = Structure.FFIType.get(clazz2).peer;
                        continue block19;
                    }
                    default: {
                        lArray3[j] = lArray2[j] = Structure.FFIType.get(Pointer.class).peer;
                    }
                }
            }
            String string4 = (String)var9_15 + I.I(16664);
            string4 = string4 + Native.getSignature(clazz3);
            Class<?>[] classArray2 = method.getExceptionTypes();
            for (int j = 0; j < classArray2.length; ++j) {
                if (!LastErrorException.class.isAssignableFrom(classArray2[j])) continue;
                bl = true;
                break;
            }
            clazz2 = nativeLibrary.getFunction(method.getName(), method);
            try {
                lArray[map2] = Native.registerMethod(clazz, method.getName(), string4, nArray, lArray3, lArray2, n, l2, l, method, ((Function)((Object)clazz2)).peer, ((Function)((Object)clazz2)).getCallingConvention(), bl, toNativeConverterArray, fromNativeConverter, ((Function)((Object)clazz2)).encoding);
                continue;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new UnsatisfiedLinkError(I.I(66296) + method.getName() + I.I(66307) + string4 + I.I(66245) + clazz);
            }
        }
        Map map3 = registeredClasses;
        synchronized (map3) {
            registeredClasses.put(clazz, lArray);
            registeredLibraries.put(clazz, nativeLibrary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map cacheOptions(Class clazz, Map map, Object object) {
        HashMap<String, Class> hashMap = new HashMap<String, Class>(map);
        hashMap.put(I.I(66183), clazz);
        Map map2 = libraries;
        synchronized (map2) {
            typeOptions.put(clazz, hashMap);
            if (object != null) {
                libraries.put(clazz, new WeakReference<Object>(object));
            }
            if (!clazz.isInterface() && Library.class.isAssignableFrom(clazz)) {
                Class<?>[] classArray;
                for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                    if (!Library.class.isAssignableFrom(clazz2)) continue;
                    Native.cacheOptions(clazz2, hashMap, object);
                    break;
                }
            }
        }
        return hashMap;
    }

    private static native long registerMethod(Class var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Method var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17, String var18);

    private static NativeMapped fromNative(Class clazz, Object object) {
        return (NativeMapped)NativeMappedConverter.getInstance(clazz).fromNative(object, new FromNativeContext(clazz));
    }

    private static NativeMapped fromNative(Method method, Object object) {
        Class<?> clazz = method.getReturnType();
        return (NativeMapped)NativeMappedConverter.getInstance(clazz).fromNative(object, new MethodResultContext(clazz, null, null, method));
    }

    private static Class nativeType(Class clazz) {
        return NativeMappedConverter.getInstance(clazz).nativeType();
    }

    private static Object toNative(ToNativeConverter toNativeConverter, Object object) {
        return toNativeConverter.toNative(object, new ToNativeContext());
    }

    private static Object fromNative(FromNativeConverter fromNativeConverter, Object object, Method method) {
        return fromNativeConverter.fromNative(object, new MethodResultContext(method.getReturnType(), null, null, method));
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    static native int initialize_ffi_type(long var0);

    public static void main(String[] stringArray) {
        String string;
        String string2;
        String string3 = I.I(66082);
        String string4 = I.I(66107);
        String string5 = I.I(66113);
        Package package_ = Native.class.getPackage();
        String string6 = string2 = package_ != null ? package_.getSpecificationTitle() : I.I(66082);
        if (string2 == null) {
            string2 = I.I(66082);
        }
        String string7 = string = package_ != null ? package_.getSpecificationVersion() : I.I(66107);
        if (string == null) {
            string = I.I(66107);
        }
        string2 = string2 + I.I(66149) + string;
        System.out.println(string2);
        String string8 = string = package_ != null ? package_.getImplementationVersion() : I.I(66113);
        if (string == null) {
            string = I.I(66113);
        }
        System.out.println(I.I(1213) + string);
        System.out.println(I.I(66163) + Native.getNativeVersion() + I.I(16661) + Native.getAPIChecksum() + I.I(16664));
        System.out.println(I.I(66173) + Platform.RESOURCE_PREFIX);
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, int var5, String var6);

    static native int invokeInt(Function var0, long var1, int var3, Object[] var4);

    static native long invokeLong(Function var0, long var1, int var3, Object[] var4);

    static native void invokeVoid(Function var0, long var1, int var3, Object[] var4);

    static native float invokeFloat(Function var0, long var1, int var3, Object[] var4);

    static native double invokeDouble(Function var0, long var1, int var3, Object[] var4);

    static native long invokePointer(Function var0, long var1, int var3, Object[] var4);

    private static native void invokeStructure(Function var0, long var1, int var3, Object[] var4, long var5, long var7);

    static Structure invokeStructure(Function function, long l, int n, Object[] objectArray, Structure structure) {
        Native.invokeStructure(function, l, n, objectArray, structure.getPointer().peer, structure.getTypeInfo().peer);
        return structure;
    }

    static native Object invokeObject(Function var0, long var1, int var3, Object[] var4);

    static long open(String string) {
        return Native.open(string, -1);
    }

    static native long open(String var0, int var1);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(Pointer var0, long var1, long var3, byte var5);

    static native void read(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static native void read(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, byte[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, short[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, char[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, int[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, long[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, float[] var5, int var6, int var7);

    static native void write(Pointer var0, long var1, long var3, double[] var5, int var6, int var7);

    static native byte getByte(Pointer var0, long var1, long var3);

    static native char getChar(Pointer var0, long var1, long var3);

    static native short getShort(Pointer var0, long var1, long var3);

    static native int getInt(Pointer var0, long var1, long var3);

    static native long getLong(Pointer var0, long var1, long var3);

    static native float getFloat(Pointer var0, long var1, long var3);

    static native double getDouble(Pointer var0, long var1, long var3);

    static Pointer getPointer(long l) {
        long l2 = Native._getPointer(l);
        return l2 == 0L ? null : new Pointer(l2);
    }

    private static native long _getPointer(long var0);

    static native String getWideString(Pointer var0, long var1, long var3);

    static String getString(Pointer pointer, long l) {
        return Native.getString(pointer, l, Native.getDefaultStringEncoding());
    }

    static String getString(Pointer pointer, long l, String string) {
        byte[] byArray = Native.getStringBytes(pointer, pointer.peer, l);
        if (string != null) {
            try {
                return new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray);
    }

    static native byte[] getStringBytes(Pointer var0, long var1, long var3);

    static native void setMemory(Pointer var0, long var1, long var3, long var5, byte var7);

    static native void setByte(Pointer var0, long var1, long var3, byte var5);

    static native void setShort(Pointer var0, long var1, long var3, short var5);

    static native void setChar(Pointer var0, long var1, long var3, char var5);

    static native void setInt(Pointer var0, long var1, long var3, int var5);

    static native void setLong(Pointer var0, long var1, long var3, long var5);

    static native void setFloat(Pointer var0, long var1, long var3, float var5);

    static native void setDouble(Pointer var0, long var1, long var3, double var5);

    static native void setPointer(Pointer var0, long var1, long var3, long var5);

    static native void setWideString(Pointer var0, long var1, long var3, String var5);

    static native ByteBuffer getDirectByteBuffer(Pointer var0, long var1, long var3, long var5);

    public static native long malloc(long var0);

    public static native void free(long var0);

    public static native ByteBuffer getDirectByteBuffer(long var0, long var2);

    public static void detach(boolean bl) {
        Thread thread = Thread.currentThread();
        if (bl) {
            nativeThreads.remove(thread);
            Pointer pointer = (Pointer)nativeThreadTerminationFlag.get();
            Native.setDetachState(true, 0L);
        } else if (!nativeThreads.containsKey(thread)) {
            Pointer pointer = (Pointer)nativeThreadTerminationFlag.get();
            nativeThreads.put(thread, pointer);
            Native.setDetachState(false, pointer.peer);
        }
    }

    static Pointer getTerminationFlag(Thread thread) {
        return (Pointer)nativeThreads.get(thread);
    }

    private static native void setDetachState(boolean var0, long var1);

    static {
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Callback callback, Throwable throwable) {
                System.err.println(I.I(67976) + callback + I.I(67991));
                throwable.printStackTrace();
            }
        };
        Native.loadNativeDispatchLibrary();
        if (!Native.isCompatibleVersion(I.I(-2629), Native.getNativeVersion())) {
            String string = System.getProperty(I.I(-2623));
            throw new Error(string + string + I.I(-2608) + string + I.I(-2539) + I.I(-2629) + string + I.I(-2528) + Native.getNativeVersion() + string + (jnidispatchPath != null ? I.I(-2517) + jnidispatchPath + I.I(16664) : System.getProperty(I.I(1028))) + I.I(1448) + string + I.I(-2512) + string + I.I(-2457) + string + I.I(-2412) + string + I.I(-2370) + string + I.I(-2298) + string);
        }
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        BOOL_SIZE = Native.sizeof(4);
        Native.initIDs();
        if (Boolean.getBoolean(I.I(-2230))) {
            Native.setProtected(true);
        }
        MAX_ALIGNMENT = Platform.isSPARC() || Platform.isWindows() || Platform.isLinux() && (Platform.isARM() || Platform.isPPC()) || Platform.isAIX() || Platform.isAndroid() ? 8 : LONG_SIZE;
        MAX_PADDING = Platform.isMac() && Platform.isPPC() ? 8 : MAX_ALIGNMENT;
        System.setProperty(I.I(-2216), I.I(10201));
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        registeredClasses = new WeakHashMap();
        registeredLibraries = new WeakHashMap();
        nativeThreadTerminationFlag = new ThreadLocal(){

            protected Memory initialValue() {
                Memory memory = new Memory(4L);
                memory.clear();
                return memory;
            }
        };
        nativeThreads = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class AWT {
        private AWT() {
        }

        static long getWindowID(Window window) throws HeadlessException {
            return AWT.getComponentID(window);
        }

        static long getComponentID(Object object) throws HeadlessException {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException(I.I(68060));
            }
            Component component = (Component)object;
            if (component.isLightweight()) {
                throw new IllegalArgumentException(I.I(68092));
            }
            if (!component.isDisplayable()) {
                throw new IllegalStateException(I.I(68122));
            }
            if (Platform.isX11() && System.getProperty(I.I(8031)).startsWith(I.I(68152)) && !component.isVisible()) {
                throw new IllegalStateException(I.I(68156));
            }
            return Native.getWindowHandle0(component);
        }
    }

    private static class Buffers {
        private Buffers() {
        }

        static boolean isBuffer(Class clazz) {
            return Buffer.class.isAssignableFrom(clazz);
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

