/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import I.I;
import com.sun.jna.AltCallingConvention;
import com.sun.jna.Callback;
import com.sun.jna.CallbackParameterContext;
import com.sun.jna.CallbackProxy;
import com.sun.jna.CallbackResultContext;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import com.sun.jna.win32.DLLCallback;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class CallbackReference
extends WeakReference {
    static final Map callbackMap = new WeakHashMap();
    static final Map directCallbackMap = new WeakHashMap();
    static final Map pointerCallbackMap = new WeakHashMap();
    static final Map allocations = new WeakHashMap();
    private static final Map allocatedMemory = Collections.synchronizedMap(new WeakHashMap());
    private static final Method PROXY_CALLBACK_METHOD;
    private static final Map initializers;
    Pointer cbstruct;
    Pointer trampoline;
    CallbackProxy proxy;
    Method method;
    int callingConvention;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CallbackThreadInitializer setCallbackThreadInitializer(Callback callback, CallbackThreadInitializer callbackThreadInitializer) {
        Map map = initializers;
        synchronized (map) {
            if (callbackThreadInitializer != null) {
                return initializers.put(callback, callbackThreadInitializer);
            }
            return (CallbackThreadInitializer)initializers.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadGroup initializeThread(Callback callback, AttachOptions attachOptions) {
        CallbackThreadInitializer callbackThreadInitializer = null;
        if (callback instanceof DefaultCallbackProxy) {
            callback = ((DefaultCallbackProxy)callback).getCallback();
        }
        Object object = initializers;
        synchronized (object) {
            callbackThreadInitializer = (CallbackThreadInitializer)initializers.get(callback);
        }
        object = null;
        if (callbackThreadInitializer != null) {
            object = callbackThreadInitializer.getThreadGroup(callback);
            attachOptions.name = callbackThreadInitializer.getName(callback);
            attachOptions.daemon = callbackThreadInitializer.isDaemon(callback);
            attachOptions.detach = callbackThreadInitializer.detach(callback);
            attachOptions.write();
        }
        return object;
    }

    public static Callback getCallback(Class clazz, Pointer pointer) {
        return CallbackReference.getCallback(clazz, pointer, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Callback getCallback(Class clazz, Pointer pointer, boolean bl) {
        if (pointer == null) {
            return null;
        }
        if (!clazz.isInterface()) {
            throw new IllegalArgumentException(I.I(-223));
        }
        Map map = bl ? directCallbackMap : callbackMap;
        Map map2 = pointerCallbackMap;
        synchronized (map2) {
            Callback callback = null;
            Reference reference = (Reference)pointerCallbackMap.get(pointer);
            if (reference != null) {
                callback = (Callback)reference.get();
                if (callback != null && !clazz.isAssignableFrom(callback.getClass())) {
                    throw new IllegalStateException(I.I(-188) + pointer + I.I(-179) + callback + I.I(-159));
                }
                return callback;
            }
            int n = AltCallingConvention.class.isAssignableFrom(clazz) ? 63 : 0;
            HashMap<String, Method> hashMap = new HashMap<String, Method>(Native.getLibraryOptions(clazz));
            hashMap.put(I.I(-2), CallbackReference.getCallbackMethod(clazz));
            NativeFunctionHandler nativeFunctionHandler = new NativeFunctionHandler(pointer, n, hashMap);
            callback = (Callback)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)nativeFunctionHandler);
            map.remove(callback);
            pointerCallbackMap.put(pointer, new WeakReference<Callback>(callback));
            return callback;
        }
    }

    private CallbackReference(Callback callback, int n, boolean bl) {
        super(callback);
        Object object;
        TypeMapper typeMapper = Native.getTypeMapper(callback.getClass());
        this.callingConvention = n;
        boolean bl2 = Platform.isPPC();
        if (bl) {
            object = CallbackReference.getCallbackMethod(callback);
            Class<?>[] classArray = ((Method)object).getParameterTypes();
            for (int j = 0; j < classArray.length; ++j) {
                if (bl2 && (classArray[j] == Float.TYPE || classArray[j] == Double.TYPE)) {
                    bl = false;
                    break;
                }
                if (typeMapper == null || typeMapper.getFromNativeConverter(classArray[j]) == null) continue;
                bl = false;
                break;
            }
            if (typeMapper != null && typeMapper.getToNativeConverter(((Method)object).getReturnType()) != null) {
                bl = false;
            }
        }
        object = Native.getStringEncoding(callback.getClass());
        long l = 0L;
        if (bl) {
            this.method = CallbackReference.getCallbackMethod(callback);
            Class[] classArray = this.method.getParameterTypes();
            Class<?> clazz = this.method.getReturnType();
            int n2 = 1;
            if (callback instanceof DLLCallback) {
                n2 |= 2;
            }
            l = Native.createNativeCallback(callback, this.method, classArray, clazz, n, n2, (String)object);
        } else {
            int n3;
            Object object2;
            this.proxy = callback instanceof CallbackProxy ? (CallbackProxy)callback : new DefaultCallbackProxy(CallbackReference.getCallbackMethod(callback), typeMapper, (String)object);
            Class[] classArray = this.proxy.getParameterTypes();
            Class clazz = this.proxy.getReturnType();
            if (typeMapper != null) {
                for (int j = 0; j < classArray.length; ++j) {
                    object2 = typeMapper.getFromNativeConverter(classArray[j]);
                    if (object2 == null) continue;
                    classArray[j] = object2.nativeType();
                }
                ToNativeConverter toNativeConverter = typeMapper.getToNativeConverter(clazz);
                if (toNativeConverter != null) {
                    clazz = toNativeConverter.nativeType();
                }
            }
            for (n3 = 0; n3 < classArray.length; ++n3) {
                classArray[n3] = this.getNativeType(classArray[n3]);
                if (CallbackReference.isAllowableNativeType(classArray[n3])) continue;
                object2 = I.I(-297) + classArray[n3] + I.I(-278);
                throw new IllegalArgumentException((String)object2);
            }
            if (!CallbackReference.isAllowableNativeType(clazz = this.getNativeType(clazz))) {
                String string = I.I(-245) + clazz + I.I(-278);
                throw new IllegalArgumentException(string);
            }
            n3 = callback instanceof DLLCallback ? 2 : 0;
            l = Native.createNativeCallback(this.proxy, PROXY_CALLBACK_METHOD, classArray, clazz, n, n3, (String)object);
        }
        this.cbstruct = l != 0L ? new Pointer(l) : null;
        allocatedMemory.put(this, new WeakReference<CallbackReference>(this));
    }

    private Class getNativeType(Class clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            Structure.validate(clazz);
            if (!Structure.ByValue.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        } else {
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                return NativeMappedConverter.getInstance(clazz).nativeType();
            }
            if (clazz == String.class || clazz == WString.class || clazz == String[].class || clazz == WString[].class || Callback.class.isAssignableFrom(clazz)) {
                return Pointer.class;
            }
        }
        return clazz;
    }

    private static Method checkMethod(Method method) {
        if (method.getParameterTypes().length > 256) {
            String string = I.I(-352) + method;
            throw new UnsupportedOperationException(string);
        }
        return method;
    }

    static Class findCallbackClass(Class clazz) {
        if (!Callback.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz.getName() + I.I(-394));
        }
        if (clazz.isInterface()) {
            return clazz;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int j = 0; j < classArray.length; ++j) {
            if (!Callback.class.isAssignableFrom(classArray[j])) continue;
            try {
                CallbackReference.getCallbackMethod(classArray[j]);
                return classArray[j];
            }
            catch (IllegalArgumentException illegalArgumentException) {
                break;
            }
        }
        if (Callback.class.isAssignableFrom(clazz.getSuperclass())) {
            return CallbackReference.findCallbackClass(clazz.getSuperclass());
        }
        return clazz;
    }

    private static Method getCallbackMethod(Callback callback) {
        return CallbackReference.getCallbackMethod(CallbackReference.findCallbackClass(callback.getClass()));
    }

    private static Method getCallbackMethod(Class clazz) {
        Method[] methodArray = clazz.getDeclaredMethods();
        Method[] methodArray2 = clazz.getMethods();
        HashSet<Method> hashSet = new HashSet<Method>(Arrays.asList(methodArray));
        hashSet.retainAll(Arrays.asList(methodArray2));
        Method[] methodArray3 = hashSet.iterator();
        while (methodArray3.hasNext()) {
            Method method = (Method)methodArray3.next();
            if (!Callback.FORBIDDEN_NAMES.contains(method.getName())) continue;
            methodArray3.remove();
        }
        methodArray3 = hashSet.toArray(new Method[hashSet.size()]);
        if (methodArray3.length == 1) {
            return CallbackReference.checkMethod(methodArray3[0]);
        }
        for (int j = 0; j < methodArray3.length; ++j) {
            Method method = methodArray3[j];
            if (!I.I(-538).equals(method.getName())) continue;
            return CallbackReference.checkMethod(method);
        }
        String string = I.I(-480);
        throw new IllegalArgumentException(string);
    }

    private void setCallbackOptions(int n) {
        this.cbstruct.setInt(Pointer.SIZE, n);
    }

    public Pointer getTrampoline() {
        if (this.trampoline == null) {
            this.trampoline = this.cbstruct.getPointer(0L);
        }
        return this.trampoline;
    }

    protected void finalize() {
        this.dispose();
    }

    protected synchronized void dispose() {
        if (this.cbstruct != null) {
            try {
                Native.freeNativeCallback(this.cbstruct.peer);
            }
            finally {
                this.cbstruct.peer = 0L;
                this.cbstruct = null;
                allocatedMemory.remove(this);
            }
        }
    }

    static void disposeAll() {
        LinkedList linkedList = new LinkedList(allocatedMemory.keySet());
        for (CallbackReference callbackReference : linkedList) {
            callbackReference.dispose();
        }
    }

    private Callback getCallback() {
        return (Callback)this.get();
    }

    private static Pointer getNativeFunctionPointer(Callback callback) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(callback.getClass()) && (invocationHandler = Proxy.getInvocationHandler(callback)) instanceof NativeFunctionHandler) {
            return ((NativeFunctionHandler)invocationHandler).getPointer();
        }
        return null;
    }

    public static Pointer getFunctionPointer(Callback callback) {
        return CallbackReference.getFunctionPointer(callback, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Pointer getFunctionPointer(Callback callback, boolean bl) {
        Pointer pointer = null;
        if (callback == null) {
            return null;
        }
        pointer = CallbackReference.getNativeFunctionPointer(callback);
        if (pointer != null) {
            return pointer;
        }
        Map map = Native.getLibraryOptions(callback.getClass());
        int n = callback instanceof AltCallingConvention ? 63 : (map != null && map.containsKey(I.I(-1359)) ? (Integer)map.get(I.I(-1359)) : 0);
        Map map2 = bl ? directCallbackMap : callbackMap;
        Map map3 = pointerCallbackMap;
        synchronized (map3) {
            CallbackReference callbackReference = (CallbackReference)map2.get(callback);
            if (callbackReference == null) {
                callbackReference = new CallbackReference(callback, n, bl);
                map2.put(callback, callbackReference);
                pointerCallbackMap.put(callbackReference.getTrampoline(), new WeakReference<Callback>(callback));
                if (initializers.containsKey(callback)) {
                    callbackReference.setCallbackOptions(1);
                }
            }
            return callbackReference.getTrampoline();
        }
    }

    private static boolean isAllowableNativeType(Class clazz) {
        return clazz == Void.TYPE || clazz == Void.class || clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == Short.TYPE || clazz == Short.class || clazz == Character.TYPE || clazz == Character.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || Structure.ByValue.class.isAssignableFrom(clazz) && Structure.class.isAssignableFrom(clazz) || Pointer.class.isAssignableFrom(clazz);
    }

    private static Pointer getNativeString(Object object, boolean bl) {
        if (object != null) {
            NativeString nativeString = new NativeString(object.toString(), bl);
            allocations.put(object, nativeString);
            return nativeString.getPointer();
        }
        return null;
    }

    static {
        try {
            PROXY_CALLBACK_METHOD = CallbackProxy.class.getMethod(I.I(-538), Object[].class);
        }
        catch (Exception exception) {
            throw new Error(I.I(-529));
        }
        initializers = new WeakHashMap();
    }

    private static class NativeFunctionHandler
    implements InvocationHandler {
        private final Function function;
        private final Map options;

        public NativeFunctionHandler(Pointer pointer, int n, Map map) {
            this.options = map;
            this.function = new Function(pointer, n, (String)map.get(I.I(-929)));
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (Library.Handler.OBJECT_TOSTRING.equals(method)) {
                String string = I.I(65638) + this.function;
                Method method2 = (Method)this.options.get(I.I(-2));
                Class clazz = CallbackReference.findCallbackClass(method2.getDeclaringClass());
                string = string + I.I(16661) + clazz.getName() + I.I(16664);
                return string;
            }
            if (Library.Handler.OBJECT_HASHCODE.equals(method)) {
                return this.hashCode();
            }
            if (Library.Handler.OBJECT_EQUALS.equals(method)) {
                Object object2 = objectArray[0];
                if (object2 != null && Proxy.isProxyClass(object2.getClass())) {
                    return Function.valueOf(Proxy.getInvocationHandler(object2) == this);
                }
                return Boolean.FALSE;
            }
            if (Function.isVarArgs(method)) {
                objectArray = Function.concatenateVarArgs(objectArray);
            }
            return this.function.invoke(method.getReturnType(), objectArray, this.options);
        }

        public Pointer getPointer() {
            return this.function;
        }
    }

    private class DefaultCallbackProxy
    implements CallbackProxy {
        private final Method callbackMethod;
        private ToNativeConverter toNative;
        private final FromNativeConverter[] fromNative;
        private final String encoding;

        public DefaultCallbackProxy(Method method, TypeMapper typeMapper, String string) {
            this.callbackMethod = method;
            this.encoding = string;
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = method.getReturnType();
            this.fromNative = new FromNativeConverter[classArray.length];
            if (NativeMapped.class.isAssignableFrom(clazz)) {
                this.toNative = NativeMappedConverter.getInstance(clazz);
            } else if (typeMapper != null) {
                this.toNative = typeMapper.getToNativeConverter(clazz);
            }
            for (int j = 0; j < this.fromNative.length; ++j) {
                if (NativeMapped.class.isAssignableFrom(classArray[j])) {
                    this.fromNative[j] = new NativeMappedConverter(classArray[j]);
                    continue;
                }
                if (typeMapper == null) continue;
                this.fromNative[j] = typeMapper.getFromNativeConverter(classArray[j]);
            }
            if (!method.isAccessible()) {
                try {
                    method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException(I.I(65569) + method);
                }
            }
        }

        public Callback getCallback() {
            return CallbackReference.this.getCallback();
        }

        private Object invokeCallback(Object[] objectArray) {
            Object object;
            Class<?>[] classArray = this.callbackMethod.getParameterTypes();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                object = classArray[j];
                Object object2 = objectArray[j];
                if (this.fromNative[j] != null) {
                    CallbackParameterContext callbackParameterContext = new CallbackParameterContext((Class)object, this.callbackMethod, objectArray, j);
                    objectArray2[j] = this.fromNative[j].fromNative(object2, callbackParameterContext);
                    continue;
                }
                objectArray2[j] = this.convertArgument(object2, (Class)object);
            }
            Object object3 = null;
            object = this.getCallback();
            if (object != null) {
                try {
                    object3 = this.convertResult(this.callbackMethod.invoke(object, objectArray2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Native.getCallbackExceptionHandler().uncaughtException((Callback)object, invocationTargetException.getTargetException());
                }
            }
            for (int j = 0; j < objectArray2.length; ++j) {
                if (!(objectArray2[j] instanceof Structure) || objectArray2[j] instanceof Structure.ByValue) continue;
                ((Structure)objectArray2[j]).autoWrite();
            }
            return object3;
        }

        @Override
        public Object callback(Object[] objectArray) {
            try {
                return this.invokeCallback(objectArray);
            }
            catch (Throwable throwable) {
                Native.getCallbackExceptionHandler().uncaughtException(this.getCallback(), throwable);
                return null;
            }
        }

        private Object convertArgument(Object object, Class clazz) {
            if (object instanceof Pointer) {
                if (clazz == String.class) {
                    object = ((Pointer)object).getString(0L, this.encoding);
                } else if (clazz == WString.class) {
                    object = new WString(((Pointer)object).getWideString(0L));
                } else if (clazz == String[].class) {
                    object = ((Pointer)object).getStringArray(0L, this.encoding);
                } else if (clazz == WString[].class) {
                    object = ((Pointer)object).getWideStringArray(0L);
                } else if (Callback.class.isAssignableFrom(clazz)) {
                    object = CallbackReference.getCallback(clazz, (Pointer)object);
                } else if (Structure.class.isAssignableFrom(clazz)) {
                    if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                        Structure structure = Structure.newInstance(clazz);
                        byte[] byArray = new byte[structure.size()];
                        ((Pointer)object).read(0L, byArray, 0, byArray.length);
                        structure.getPointer().write(0L, byArray, 0, byArray.length);
                        structure.read();
                        object = structure;
                    } else {
                        Structure structure = Structure.newInstance(clazz, (Pointer)object);
                        structure.conditionalAutoRead();
                        object = structure;
                    }
                }
            } else if ((Boolean.TYPE == clazz || Boolean.class == clazz) && object instanceof Number) {
                object = Function.valueOf(((Number)object).intValue() != 0);
            }
            return object;
        }

        private Object convertResult(Object object) {
            if (this.toNative != null) {
                object = this.toNative.toNative(object, new CallbackResultContext(this.callbackMethod));
            }
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            if (Structure.class.isAssignableFrom(clazz)) {
                if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                    return object;
                }
                return ((Structure)object).getPointer();
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return Boolean.TRUE.equals(object) ? Function.INTEGER_TRUE : Function.INTEGER_FALSE;
            }
            if (clazz == String.class || clazz == WString.class) {
                return CallbackReference.getNativeString(object, clazz == WString.class);
            }
            if (clazz == String[].class || clazz == WString.class) {
                StringArray stringArray = clazz == String[].class ? new StringArray((String[])object, this.encoding) : new StringArray((WString[])object);
                allocations.put(object, stringArray);
                return stringArray;
            }
            if (Callback.class.isAssignableFrom(clazz)) {
                return CallbackReference.getFunctionPointer((Callback)object);
            }
            return object;
        }

        @Override
        public Class[] getParameterTypes() {
            return this.callbackMethod.getParameterTypes();
        }

        @Override
        public Class getReturnType() {
            return this.callbackMethod.getReturnType();
        }
    }

    static class AttachOptions
    extends Structure {
        public static final List FIELDS = AttachOptions.createFieldsOrder(I.I(65550), I.I(65557), I.I(17096));
        public boolean daemon;
        public boolean detach;
        public String name;

        AttachOptions() {
            this.setStringEncoding(I.I(65564));
        }

        @Override
        protected List getFieldOrder() {
            return FIELDS;
        }
    }
}

